<?php
require_once '../../../../configuration/config.inc.php';
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
use xo\cms\core\Configuration;
use xo\authtoken\AuthTokenService;
session_start ();

$requestCode = "UPDATE_PASSWORD_FORM";
$result = new JavaScriptRequestResultWrapper ( array (
		"password",
		"password2" 
) );
$db = Configuration::getInstance ()->db ();
$authTokenService = new AuthTokenService ( $db );
$result->message = "";
$error = false;
$httpRequest = new HttpRequest ();

if ($httpRequest->hasPostData ( "token" )) {
	$tokenStr = $httpRequest->getPostDataAsText ( "token" );
	$token = $authTokenService->getToken ( $tokenStr );
} else {
	$error = true;
	$result->message = "Veuillez vérifier l'adresse internet";
}

$isGranted = ! $error && $token->isValid ( "UPDATE_PASSWORD" );
if ($isGranted) {
	if ($httpRequest->hasPostData ( "password" )) {
		$password = $httpRequest->getPostDataAsText ( "password" );
	} else {
		$error = true;
		$result->message = "Le champ 'Mot de passe' n'est pas rempli.";
	}
	if ($httpRequest->hasPostData ( "password2" )) {
		$password2 = $httpRequest->getPostDataAsText ( "password2" );
	} else {
		$error = true;
		$result->message = "Le champ 'Confirmation' n'est pas rempli.";
	}
	
	if ($password != $password2) {
		$error = true;
		$result->message = "Les champs 'Mot de passe' et 'Confirmation' doivent correspondre.";
	}
	
	if (! $error) {
		$payLoad = json_decode ( $token->getPayload () );
		$email = $payLoad->email;
		error_log ( "Udate password for email $email {$payLoad->email}" );
		$result->message = "Votre mot de passe a été modifié.";
		$result->done = true;
	} else {
		echo "ERROR";
	}
}

ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?> 