<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\Template;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
use xo\message\MessageService;
use xo\cms\core\Configuration;
use xo\core\ServiceFunctionalException;
session_start ();

$requestCode = "JOIN_FORM";
$result = new JavaScriptRequestResultWrapper ( array (
		"title",
		"name",
		"firstname",
		"address",
		"zip",
		"city",
		"phone",
		"email",
		"corporation",
		"locality",
		"activity",
		"situation" 
) );
$result->message = "";
$error = false;
$httpRequest = new HttpRequest ();
$title = null;
$name = null;
$firstname = null;
$address = null;
$zip = null;
$city = null;
$phone = null;
$email = null;
$corporation = null;
$locality = null;
$activity = null;
$situation = null;

if ($httpRequest->hasPostData ( "title" )) {
	$title = $httpRequest->getPostDataAsText ( "title" );
} else {
	$error = true;
	$result->message = "Le champ 'Civilité' n'est pas rempli.";
}
if ($httpRequest->hasPostData ( "name" )) {
	$name = $httpRequest->getPostDataAsText ( "name" );
} else {
	$error = true;
	$result->message = "Le champ 'Nom' n'est pas rempli.";
}
if ($httpRequest->hasPostData ( "firstname" )) {
	$firstname = $httpRequest->getPostDataAsText ( "firstname" );
} else {
	$error = true;
	$result->message = "Le champ 'Prénom' n'est pas rempli";
}
if ($httpRequest->hasPostData ( "phone" )) {
	$phone = $httpRequest->getPostDataAsText ( "phone" );
} else {
	$error = true;
	$result->message = "Le champ 'Téléphone' n'est pas rempli.";
}
if ($httpRequest->hasPostData ( "email" )) {
	$email = $httpRequest->getPostDataAsText ( "email" );
} else {
	$error = true;
	$result->message = "Le champ 'Email' n'est pas rempli.";
}

if ($httpRequest->hasPostData ( "address" )) {
	$address = $httpRequest->getPostDataAsText ( "address" );
}
if ($httpRequest->hasPostData ( "zip" )) {
	$zip = $httpRequest->getPostDataAsText ( "zip" );
} else {
	$error = true;
	$result->message = "Le champ 'Code postal' n'est pas rempli.";
}

if ($httpRequest->hasPostData ( "city" )) {
	$city = $httpRequest->getPostDataAsText ( "city" );
	if ($address == null || empty ( $address )) {
		$error = true;
		$result->message = "Le champ 'Adresse' doit être rempli si le champ 'Ville' est rempli.";
	}
} else {
	if (! empty ( $address )) {
		$error = true;
		$result->message = "Le champ 'Ville' doit être rempli si le champ 'Adresse' est rempli";
	}
}
if ($httpRequest->hasPostData ( "corporation" )) {
	$corporation = $httpRequest->getPostDataAsText ( "corporation" );
} else {
	$error = true;
	$result->message = "Le champ 'Votre entreprise' n'est pas rempli.";
}
if ($httpRequest->hasPostData ( "locality" )) {
	$locality = $httpRequest->getPostDataAsText ( "locality" );
} else {
	$error = true;
	$result->message = "Le champ 'Sa localité' n'est pas rempli.";
}
if ($httpRequest->hasPostData ( "activity" )) {
	$activity = $httpRequest->getPostDataAsText ( "activity" );
}
if ($httpRequest->hasPostData ( "situation" )) {
	$situation = $httpRequest->getPostDataAsText ( "situation" );
} else {
	$error = true;
	$result->message = "Le champ 'Votre situation professionnelle' n'est pas rempli.";
}
if (! $error) {
	$template = new Template ( 'email', "FR", "join-body" );
	$ctx = array ();
	$ctx ["title"] = $title;
	$ctx ["name"] = $name;
	$ctx ["firstname"] = $firstname;
	$ctx ["address"] = $address;
	$ctx ["zip"] = $zip;
	$ctx ["city"] = $city;
	$ctx ["phone"] = $phone;
	$ctx ["email"] = $email;
	$ctx ["corporation"] = $corporation;
	$ctx ["locality"] = $locality;
	$ctx ["activity"] = $activity;
	$ctx ["situation"] = $situation;
	$body = $template->renderToString ( $ctx );
	try {
		$messageService = new MessageService ( Configuration::getInstance ()->db () );
		$configurations = $messageService->getConfigurations ();
		$to = '';
		foreach ( $configurations as $config ) {
			if ($config->type->getCode () == 1) {
				$to = $config->from;
				$emailSubject = $config->subject;
			}
		}
		$messageService->createMessage ( 1, $to, $emailSubject, $body );
		$result->message = "Votre demande a été prise en compte.";
		$result->done = true;
	} catch ( ServiceFunctionalException $e ) {
		$result->message = $e->getFunctionalError ()->getMessage ();
	}
} else {
	echo "ERROR";
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?> 