<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\Template;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
use xo\message\MessageService;
use xo\cms\core\Configuration;
use xo\core\ServiceFunctionalException;
use xo\authtoken\AuthTokenService;
session_start ();
$requestCode = "ASK_FOR_PASSWORD_UPDATE_FORM";
$result = new JavaScriptRequestResultWrapper ( array (
		"email" 
) );
$result->message = "";
$error = false;
$httpRequest = new HttpRequest ();

$email = null;

$configType = 3;
if ($httpRequest->hasPostData ( "email" )) {
	$email = $httpRequest->getPostDataAsText ( "email" );
} else {
	$error = true;
	$result->message = "Le champ 'Email' n'est pas rempli.";
}

if (! $error) {
	
	$emailHasAccount = ($email == "contact@thierryleroy.com") || ($email == "mail@freddumur.com");
	if ($emailHasAccount) {
		$db = Configuration::getInstance ()->db ();
		$authTokenService = new AuthTokenService ( $db );
		
		$payload = new stdClass ();
		$payload->email = $email;
		$payloadStr = json_encode ( $payload );
		$now = time ();
		$token = $authTokenService->createToken ( "UPDATE_PASSWORD", $payloadStr, $now, $now + 60 * 15 );
		$tokenStr = $token->getTokenAsString ();
		
		$template = new Template ( 'email', "FR", "ask-for-password-update-body" );
		$ctx = array ();
		$ctx ["link"] = "http://www.fecfo.fr/changement-mot-de-passe-2?token=$tokenStr";
		$body = $template->renderToString ( $ctx );
		try {
			$messageService = new MessageService ( $db );
			$configurations = $messageService->getConfigurations ();
			$to = '';
			foreach ( $configurations as $config ) {
				if ($config->type->getCode () == $configType) {
					$to = $email;
					$emailSubject = $config->subject;
				}
			}
			$messageService->createMessage ( $configType, $to, $emailSubject, $body );
			$messageService->sendMessages ();
			$result->message = "Votre demande a été prise en compte.";
			$result->done = true;
		} catch ( ServiceFunctionalException $e ) {
			$result->message = $e->getFunctionalError ()->getMessage ();
		}
	} else {
		$error = true;
		$result->message = "Aucun compte n'a été trouvé lié à l'email $email.";
	}
} else {
	echo "ERROR";
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?> 