define([], function() {
    function GEDParameters() {
	this.query = null;
	this.type = 1;
	this.section = 0;
	this.page = 0;

    }
    GEDParameters.prototype = Object.create(Object.prototype);
    GEDParameters.prototype.clone = function() {
	var clone = new GEDParameters();
	clone.query = this.query;
	clone.type = this.type;
	clone.section = this.section;
	clone.page = this.page;
	return clone;
    };
    GEDParameters.prototype.getQuery = function() {
	return this.query;
    };
    GEDParameters.prototype.hasQuery = function() {
	return this.query !== null;
    };
    GEDParameters.prototype.setQuery = function(query) {
	this.query = query === null ? null : query.trim();
    };
    GEDParameters.prototype.hasType = function() {
	return this.type !== null;
    };
    GEDParameters.prototype.setType = function(type) {
	this.type = type;
    };
    GEDParameters.prototype.getType = function() {
	return this.type;
    };
    GEDParameters.prototype.setSection = function(section) {
	this.section = section;
    };
    GEDParameters.prototype.hasSection = function() {
	return this.section !== null;
    };
    GEDParameters.prototype.getSection = function() {
	return this.section;
    };
    GEDParameters.prototype.getPage = function() {
	return this.page;
    };

    GEDParameters.prototype.setPage = function(page) {
	this.page = page;
    };
    GEDParameters.prototype.createHash = function() {
	var hash = this.type;
	hash += ":";
	if (this.hasSection()) {
	    hash += this.section;
	}
	hash += ":";
	hash += this.page;
	hash += ":";
	if (this.hasQuery()) {
	    hash += this.query;
	}
	return hash;
	 
    };

    function GEDService(serviceURL) {
	this.currentParameters = new GEDParameters();
	this.serviceURL = serviceURL;
    }
    GEDService.prototype = Object.create(Object.prototype);

    GEDService.prototype.getCurrentParameters = function() {
	return this.currentParameters.clone();
    };
    GEDService.prototype.readParametersFromHash = function(hash) {
	hash = hash.replace(/^#!?/, "");
	if (hash != "") {
	    var re = /(\d+):(\d*):(\d+):(.*)/;
	    var result = re.exec(hash);
	    if (result !== null) {
		var type = parseInt(result[1]);
		var section = result[2] == '' ? 0 : parseInt(result[2]);
		var page = result[3] == '' ? 0 : parseInt(result[3]);
		var query = result[4] == '' ? null : result[4];
		return {
		    type : type,
		    query : query,
		    page : page,
		    section : section
		}
	    }
	}
	return null;
    }
    GEDService.prototype.loadParametersFromHash = function(hash) {
	var parameter = this.readParametersFromHash(hash);
	if (hash != "") {
	    this.currentParameters.setQuery(parameter.query)
	    this.currentParameters.setSection(parameter.section);
	    this.currentParameters.setType(parameter.type);
	    this.currentParameters.setPage(parameter.page);
	}
    };

    GEDService.prototype.createSearchUrl = function(params, filters) {
	var url = this.serviceURL + 'doclst.asp?rss=11&for=xml&opt=doc&pro=des&bus=4444404303324384404404584444404503324584444404323324584444404203323083084584064044403323063083003063063143103083083061&lan=fr';
	if (params.hasType()) {
	    switch (params.getType()) {
	    // Communiqués
	    case 2:
		url += "&doc_cac_202_I00=";
		url += "COM";
		break;
	    // Publications
	    case 3:
		url += "&doc_cac_202_I00=";
		url += encodeURIComponent("AFF;ARC;CIR;CON;CPT;DEL;INS;JEC;PER;PRA;PRO;PUB;REF;STA;TRA");
		break;
	    // Multimedia
	    case 4:
		url += "&doc_cac_202_I00=";
		url += encodeURIComponent("IMG;VID;VLI");
		break;
	    }
	}

	if (params.hasSection()) {
	    var sections = this.getSections();
	    for (var i = 0; i < sections.length; i++) {
		for (var j = 0; j < sections[i].length; j++) {
			if(sections[i][j]){
		    if (sections[i][j].id === params.getSection()) {
			switch (params.getSection()) {
			case 200:
			case 201:
			case 202:
			case 203: 
			    url += "&doc_sni_131_300=76";
			    url += "&doc_sri_131_300=" + sections[i][j].gedId;
			    break;
			default: 
			    url += "&doc_sni_131_300=" + sections[i][j].gedId;
			}

			break;
		    }
			}
		}
	    }

	}
	if (filters !== null && filters !== undefined) {
	    for ( var key in filters) {
		url += "&" + key + "=" + encodeURIComponent(filters[key]);
	    }
	}

	if (params.hasQuery()) {
	    url += "&par_ord=docedi+desc";
	    url += "&doc_www_202_500_000_ns=" + encodeURIComponent(params.getQuery());
	}

	var perPage = 5;
	if (filters == undefined || !("rcs" in filters)) {
	    if (filters == undefined || !("rcs" in filters)) {
		url += "&rcs=";
		url += perPage;
	    }
	}
	url += "&rcn=";
	url += params.page * 5 + 1;

	if (filters == undefined || !("par_max" in filters)) {
	    url += "&par_max=200";
	}

	return url;
    }

    GEDService.prototype.xmlToJson = function(node) {
	var linkElt = node.querySelector("link");
	var id = parseInt(node.getAttribute("key")); 
	var titleElt = node.querySelector("title");
	var pubDateElt = node.querySelector("pubDate"); 
	var categoryElt = node.querySelector("category");
	var description = null;
	var category = null;
	var secteur = null;
	var secteur2 = null;
	if (categoryElt != null && categoryElt != undefined) {
	    var categorySplit = categoryElt.textContent.split("  ");
	    if (categorySplit.length > 1) {
		category = this.getCategoryFromCategoryCode(categorySplit[1]);
	    }
	    if (categorySplit.length > 2) {
		secteur = categorySplit[2];
	    }
	    if (categorySplit.length > 3) {
		secteur2 = categorySplit[3];
	    }

	}

	var splitTitle = titleElt.textContent.split('||');
	
	var title = splitTitle.length > 0 ? splitTitle[0] : null;
	var subTitle = splitTitle.length > 1 ? splitTitle[1] : null;

	var date = pubDateElt == null ? null : new Date(pubDateElt.textContent);
	try {
	    return {
		"id" : id,
		"link" : linkElt.textContent.replace(".local", ".fr"),
		"publicationDate" : date,
		"title" : title,
		"description" : subTitle,
		"category" : category,
		"secteur" : secteur,
		"secteur2" : secteur2
	    }
	} catch (e) {
	    console.log("Erreur");
	    // console.log(e);
	    return null;
	}
    }
    GEDService.prototype.getTypeFromCategory = function(category) {
	if (category === null) {
	    return 1;
	}
	var categoryCode = category.substr(0, 3).toUpperCase();
	return this.getTypeFromCategoryCode(categoryCode);
    };
    GEDService.prototype.getCategoryFromCategoryCode = function(categoryCode) {
	switch (categoryCode) {
	case 'COM':
	    return 'Communiqués';
	case 'AFF':
	case 'ARC':
	case 'CIR':
	case 'CON':
	case 'CPT':
	case 'DEL':
	case 'INS':
	case 'JEC':
	case 'PER':
	case 'PRA':
	case 'PRO':
	case 'PUB':
	case 'REF':
	case 'STA':
	case 'TRA': 
	case 'CR':    
	    return 'Publication';
	case 'VLI':
	case 'IMG':
	case 'VID':
	    return 'Multimédia';
	default:
	    return 'Actualité';
	}
    }
    GEDService.prototype.getTypeFromCategoryCode = function(categoryCode) {
	switch (categoryCode) {
	case 'COM':
	    return 2;
	case 'AFF':
	case 'ARC':
	case 'CIR':
	case 'CON':
	case 'CPT':
	case 'DEL':
	case 'INS':
	case 'JEC':
	case 'PER':
	case 'PRA':
	case 'PRO':
	case 'PUB':
	case 'REF':
	case 'STA':
	case 'TRA': 
	case 'CR':    
	    return 3;
	case 'VLI':
	case 'IMG':
	case 'VID':
	    return 4;
	default:
	    return 1;
	}

    };

    GEDService.prototype.articleDetailsToJson = function(node, articleId) {
	var id = articleId;
	var link = null;
	var date = null;
	var title = null;
	var subTitle = null;
	var description = null;
	var html = null;
	var img = null;
	var category = null;
	var secteur = null;
	var secteur2=null;
	var embedCode = null;
	var type = null;
	 
	var map=null;
	function readField(key){
		if(map===null){
			var css='item d10';
			var itemElts= node.querySelectorAll(css);
			map={};
			for(var i=0;i<itemElts.length;i++){
				var itemElt=itemElts.item(i);
				var value=itemElt.textContent.trim()
				var parentElt=itemElt.parentNode;
				
				if(parentElt.hasAttribute("key")){
					//from key attribute
					map[parentElt.getAttribute("key")]=value;
				}else{
					//from key element
					var keyElt=parentElt.querySelector("key");
					if(keyElt!==null){
						map[keyElt.textContent.trim()]=value;
					}
				}
			}
			console.log(map);
		}
		
		return key in map? map[key] : null;
	} 
	
	var pathElt = node.querySelector("path");
	
	
	var fileField=readField("doc_fic");
	if (fileField == '*') {
	    return null;
	}
	 
	if (pathElt !== null && fileField !== null) {
		var pathStr=pathElt.textContent.replace(".local", ".fr");
		if(!pathStr.endsWith('/') && !fileField.startsWith('/') ){
			pathStr=pathStr+'/';
		}
		link =pathStr  + fileField;
	} else {
		var embedCode=readField("doc_lin");
		
	}
	 

	title=readField("doc_obj");
	 
	var docNum=readField("doc_num");
	if (docNum !== null) {
	    title = title + " - " + docNum.toUpperCase();
	}
	 
	subTitle=readField("doc_obs");
	 
	description = readField("doc_des");
	 
	
	var pubDateField  = readField("doc_pub");
	if (pubDateField !== null) {
	    date = new Date(pubDateField);
	}

	 
	
	var catField =  readField("doc_kat");
	if (catField !== null) {
	    var catCode = catField.substr(0, 3);
	    category = this.getCategoryFromCategoryCode(catCode);
	    type = this.getTypeFromCategory(catCode);
	}

 
	
	secteur=  readField("doc_sni");
 
	secteur2 =  readField("doc_sri");
	
	if (type == null) {

	}
	try {
	    var response = {
		"id" : id,
		"link" : link,
		"publicationDate" : date,
		"title" : title,
		"subTitle" : subTitle,
		"description" : description,
		"img" : img,
		"html" : html,
		"category" : category,
		"secteur" : secteur,
		"type" : type,
		"embedCode" : embedCode,
		"secteur2" : secteur2
	    };
	    return response;
	} catch (e) {
	    console.log("Erreur");
	    // console.log(e);
	    return null;
	}
    }
    GEDService.prototype.search = function(params, callback, filters) {
	var req = new XMLHttpRequest();
	var url = this.createSearchUrl(params, filters);
	var emptyResponse = {
	    "offset" : 0,
	    "count" : 0,
	    "items" : []
	}
	req.open('GET', url, true);
	req.onreadystatechange = function(aEvt) {
	    if (req.readyState == 4) {
		if (req.status == 200) {
		    var doc = req.responseXML;
		    if (doc !== null) {
			var nodes = doc.getElementsByTagName("item");
			var count = 0;
			if (nodes !== null) {
			    var countNode = doc.getElementsByTagName("count");
			    count = nodes.length;
			    if (countNode != null && countNode.length > 0) {
				count = parseInt(countNode.item(0).textContent, 10)
			    }
			    var items = [];
			    for (var i = 0; i < nodes.length; i++) {
				items.push(this.xmlToJson(nodes.item(i)));
			    }
			    callback({
				"offset" : params.getPage() * 5,
				"count" : count,
				"items" : items
			    });
			} else {
			    callback(emptyResponse);
			}
		    } else {
			callback(null, true);
		    }

		} else {
		    callback(null, true);
		}
	    }
	}.bind(this);
	req.send(null);
    }
    GEDService.prototype.createArticleUrl = function(id) {
	var url = this.serviceURL + "doslst.asp?res=fec&rss=11&for=xml&opt=fld&pro=des&key=" + id + "&bus=4444404303324384404404584444404503324584444404323324584444404203323083084584064044403323063083003063063143103083083061";
	return url;
    }

    GEDService.prototype.lookup = function(articleId, callback) {
	var req = new XMLHttpRequest();
	var url = this.createArticleUrl(articleId)
	req.open('GET', url, true);
	req.onreadystatechange = function(aEvt) {
	    if (req.readyState == 4) {
		if (req.status == 200) {
		    var doc = req.responseXML;
		    if (doc !== null) {
			callback(this.articleDetailsToJson(doc, articleId));
		    } else {
			callback(null);
		    }

		} else {
		    callback(null);
		}
	    }
	}.bind(this);
	req.send(null);
    }
    GEDService.prototype.createGEDUrl = function(usv) {
	return "http://ged.fecfo.fr/portal/dms/dms-auto.asp?cmd=set&res=fec&usv=" + usv;
    }
    GEDService.prototype.geCarrouselImageURL = function(key) {
	return "http://ged.fecfo.fr/portal-dom/documentation/images/carrousel/" + key + ".jpg";
    }
    GEDService.prototype.geArticleImageURL = function(key) {
	return "http://ged.fecfo.fr/portal-dom/documentation/images/vignette/" + key + ".jpg";
    }
    GEDService.prototype.getCarrouselLinkUrl = function() {
	var url = this.serviceURL;
	url += 'doclst.asp?rss=11&for=xml&opt=doc&pro=des&bus=4444404303324384404404584444404503324584444404323324584444404203323083084584064044403323063083003063063143103083083061&lan=fr';
	url += '&doc_dip_131_300=2';
	return url;
    }

    GEDService.prototype.getCarrouselItems = function(callback) {
	var req = new XMLHttpRequest();
	var url = this.getCarrouselLinkUrl()
	req.open('GET', url, true);
	req.onreadystatechange = function(aEvt) {
	    if (req.readyState == 4) {
		if (req.status == 200) {
		    var items = [];
		    if (req.responseXML != null) {
			var nodes = req.responseXML.getElementsByTagName("item");
			if (nodes !== null) {
			    for (var i = 0; i < nodes.length; i++) {
				items.push(this.xmlToJson(nodes.item(i)));
			    }
			}
		    }
		    callback(items);
		} else {
		    callback([]);
		}
	    }
	}.bind(this);
	req.send(null);
    }

    GEDService.prototype.goToGed = function(usv) {
	open(this.createGEDUrl(usv), "_BLANK");
    };

    GEDService.prototype.login = function(res, login, password, onSuccess, onError) {
	var req = new XMLHttpRequest();
	req.onreadystatechange = function() {
	    if (this.readyState === 4) {
		if (this.status === 200) {
		    onSuccess(this.responseXML);

		} else {
		    onError();
		}
	    }
	};
	url = this.serviceURL + "srvcnx.asp?cmd=set&res=" + res;
	url += "&usn=" + encodeURIComponent(login);
	url += "&pwd=" + encodeURIComponent(password);
	req.open('GET', url, true);
	req.send();
    };

    GEDService.prototype.getInstances = function(section, callback) {
	var map = {
	    0 : "120f62e458ce487a91eb30a80d42f860",
	    100 : "97fd20b7ecc448618614dd29703e75aa",
	    101 : "ea9c5d13c9154f2cab49977db6ecd072",
	    102 : "1e52b48ff2604f7388f437b699825006",
	    103 : "9784cf53277146d99ea2a091cca3e8b5",
	    104 : "f4ccd1c30a9843e490846eda30a7ebd8",
	    105 : "0614fe1020944ca18593a87a4efd0a96",
	    106 : "1641a34c42824f75b1be823c4bb6622c",
	    107 : "7ee6e979a13e4adeb8326ce5b2e64a84",
	    108 : "0e69edc97a834eb1a976ab78194d1bcf",
	    109 : "aded9072a8a643959a88acc12397d9cd",
	    110 : "a210bddfffcb46a7b9661c693cf6b5e5", 
	    200 : "de2504456b9a405f9cd1c8d0b292b001",
	    201 : "4ece7ca183d3451888eeb835a902977d",
	    202 : "de5fa90d14ad4af0a409d7538af89c89",
	    203 : "ad93472b902b4d6b9a18ec8f45a858c1"

	}
	var url = null;
	if (section in map) {
	    var resourceId = map[section];
	    url = "/data/" + resourceId;
	    var req = new XMLHttpRequest();
	    req.onreadystatechange = function() {
		if (this.readyState === 4) {
		    if (this.status === 200) {
			var html = '<div data-res-id="';
			html += resourceId;
			html += '" >';
			html += this.responseText;
			html += "</div>";
			callback(html);
		    }
		}
	    };
	    req.open('GET', url, true);
	    req.send();
	} else {
	    callback("");
	}
    };

    GEDService.prototype.getExternalLinks = function(section, callback) {
	var map = {
	    100 : "f19290c39fe3416db3a7dd9bf3119a02",
	    101 : "3e65888c843248269466584853f8e570",
	    102 : "d29ca7be564243f294257a18bc7fb780",
	    103 : "53ae776ab81f4e44a56d2efff0c9516b",
	    104 : "f19cd63c1212420c8d06402a90892b08",
	    105 : "bde6d6c22e694353be7a29cf5f47bd4a",
	    106 : "2fa961cdd1cd479db8ae6a3bf809c4de",
	    107 : "0b6f9ff0a65d44aa88892c18e870be47",
	    108 : "1b49c89e7c4a46d5a9abc14ab9e92d8b",
	    109 : "582461f269f44667875faf9073f9699b",
	    110 : "c80fd181ad694a108a7697e45c9d7f47", 
	    200 : "755010f42aa8436786e06f31e7015a9d",
	    201 : "25e0a12cd176440d87dd742acaadcf85",
	    202 : "0cd84990b0a043b3b2b42d03c964d838",
	    203 : "05dffcde99e84c9087cf888dc47cda2e"

	}
	var url = null;
	if (section in map) {
	    var resourceId = map[section];
	    url = "/data/" + resourceId;
	    var req = new XMLHttpRequest();
	    req.onreadystatechange = function() {
		if (this.readyState === 4) {
		    if (this.status === 200) {
			var html = '<div data-res-id="';
			html += resourceId;
			html += '" >';
			html += this.responseText;
			html += "</div>";
			callback(html);
		    }
		}
	    };
	    req.open('GET', url, true);
	    req.send();
	} else {
	    callback("");
	}

    };

    GEDService.prototype.getSections = function(callback) {
	var sections = [ [ {
	    "id" : 100,
	    "code" : "assurances",
	    "label" : "Assurances",
	    "gedId" : 69
	}, {
	    "id" : 101,
	    "code" : "Crédit",
	    "label" : "Crédit",
	    "gedId" : 1
	}, {
	    "id" : 102,
	    "code" : "casinos et cercles de jeux",
	    "label" : "Cercles & Casinos",
	    "gedId" : 66
	}, {
	    "id" : 103,
	    "code" : "cies de navigation",
	    "label" : "Cies de Navigation",
	    "gedId" : 68
	}, {
	    "id" : 104,
	    "code" : "clercs de notaires",
	    "label" : "Clercs de Notaire",
	    "gedId" : 70
	}, {
	    "id" : 105,
	    "code" : "commerce",
	    "label" : "Commerce & VRP",
	    "gedId" : 67
	}, {
	    "id" : 106,
	    "code" : "organismes agricoles",
	    "label" : "Organismes Agricoles",
	    "gedId" : 50
	}, {
	    "id" : 107,
	    "code" : "organismes sociaux",
	    "label" : "Organismes Sociaux",
	    "gedId" : 49
	}, {
	    "id" : 108,
	    "code" : "osdd",
	    "label" : "Organismes Sociaux Divers & Divers",
	    "gedId" : 65
	}, {
	    "id" : 109,
	    "code" : "Presse, Edition, Publicité",
	    "label" : "Presse, Edition & Publicité",
	    "gedId" : 73
	}, {
	    "id" : 110,
	    "code" : "services",
	    "label" : "Services",
	    "gedId" : 74
	},
	 
	{
	    "id" : 112,
	    "code" : "compte rendu",
	    "label" : "Compte rendu",
	    "gedId" : 80
	}

	], [ {
	    "id" : 203,
	    "code" : "cadres",
	    "label" : "Cadres",
	    "gedId" : 219
	}, {
	    "id" : 200,
	    "code" : "Groupe retraités",
	    "label" : "Groupe retraités",
	    "gedId" : 206
	}, {
	    "id" : 201,
	    "code" : "handicap",
	    "label" : "Handicap",
	    "gedId" : 207
	}, {
	    "id" : 202,
	    "code" : "juridique",
	    "label" : "Juridique",
	    "gedId" : 205
	} ] ]
	if (callback !== undefined) {
	    callback(sections);
	} else {
	    return sections;
	}

    }

    GEDService.prototype.readArticleIdFromHash = function(hash) {
	var hash = location.hash.replace(/^#!?/, "");
	var articleIdStr = /(\d+)-.*/.exec(hash)[1];
	return parseInt(articleIdStr);
    }

    return {
	"GEDParameters" : GEDParameters,
	"GEDService" : GEDService
    }

});