//require.config({
//	urlArgs : "v=" + (new Date()).getTime()
//});
if (!String.prototype.startsWith) {
    String.prototype.startsWith = function(searchString, position) {
	position = position || 0;
	return this.indexOf(searchString, position) === position;
    };
}
if (!String.prototype.endsWith) {
    String.prototype.endsWith = function(searchString, position) {
	var subjectString = this.toString();
	if (typeof position !== 'number' || !isFinite(position) || Math.floor(position) !== position || position > subjectString.length) {
	    position = subjectString.length;
	}
	position -= searchString.length;
	var lastIndex = subjectString.indexOf(searchString, position);
	return lastIndex !== -1 && lastIndex === position;
    };
}

require([ "ged", "request", "removeDiacritics" ], function(ged, RequestHelper, removeDiacritics) {
    var GED_SERVICE_URL = "http://ged.fecfo.fr/portal/dms/pro/";

    var gedService = new ged.GEDService(GED_SERVICE_URL);

    function selectLink(item) {
	var selected = false;
	item.classList.add('selected');
	// select parent
	var tmp = item;
	while (!(tmp === null || tmp === undefined || !("classList" in tmp))) {
	    if (tmp.classList.contains("btn") || tmp.classList.contains("items") || tmp.classList.contains("item")) {
		tmp.classList.add('selected');
		selected = true;
		break;
	    }
	    tmp = tmp.parentNode;
	}
	// change over image
	var imgs = item.querySelectorAll("img[data-src-over]");
	if (imgs != null && imgs != undefined && imgs.length > 0) {
	    for (var i = 0; i < imgs.length; i++) {
		img = imgs[i];
		img.src = img.getAttribute("data-src-over");
	    }
	}
    }
    function doSocialLinks() {
	function getText() {
	    var titleElt = document.querySelector('.articleWrap .article .title');
	    return encodeURIComponent(titleElt.textContent);
	}
	function getURL() {
	     return location.href.replace('#', '%23');
	}

	var openFB = function(evt) {
	    evt.preventDefault();
	    evt.stopPropagation();
	    var url = 'http://www.facebook.com/sharer.php?title=' + getText() + '&u=' + getURL();
	    open(url, 'facebook');

	};

	var openTwitter = function(evt) {
	    evt.preventDefault();
	    evt.stopPropagation();
	    var url = 'http://twitter.com/share?url=' + getURL() + '&text=' + getText();
	    open(url, 'twitter');
	};

	var openGPlus = function(evt) {
	    evt.preventDefault();
	    evt.stopPropagation();
	    // var url = 'https://plusone.google.com/_/+1/confirm?hl=fr-FR' +
	    // '&text=' + getText() + '&url=' + getURL();
	    var url = 'https://plus.google.com/share?hl=fr-FR' + '&text=' + getText() + '&url=' + getURL();
	     open(url, 'google');

	};

	var fbElts = document.querySelectorAll(".socialLinks .facebook");
	if (fbElts !== null && fbElts !== undefined) {
	    for (var i = 0; i < fbElts.length; i++) {
		var fbElt = fbElts.item(i);
		fbElt.addEventListener("click", openFB);
	    }
	}
	var twElts = document.querySelectorAll(".socialLinks .twitter");
	if (twElts !== null && twElts !== undefined) {
	    for (var i = 0; i < twElts.length; i++) {
		var twElt = twElts.item(i);
		twElt.addEventListener("click", openTwitter);
	    }
	}
	var gpElts = document.querySelectorAll(".socialLinks .gplus");
	if (gpElts !== null && gpElts !== undefined) {
	    for (var i = 0; i < gpElts.length; i++) {
		var gpElt = gpElts.item(i);
		gpElt.addEventListener("click", openGPlus);
	    }
	}

    }
    function doMap() {
	var mapElt = document.getElementById("gmap_canvas");

	if (mapElt !== null && mapElt !== undefined) {

	    var myOptions = {
		zoom : 15,
		center : new google.maps.LatLng(48.8742768, 2.3507953),
		mapTypeId : google.maps.MapTypeId.ROADMAP
	    };
	    map = new google.maps.Map(mapElt, myOptions);
	    marker = new google.maps.Marker({
		map : map,
		position : new google.maps.LatLng(48.8742768, 2.3507953),

	    });

	    infowindow = new google.maps.InfoWindow({
		content : "FECFO<br/>54 rue d'Hauteville<br/>75010 PARIS - France"
	    });

	    google.maps.event.addListener(marker, "click", function() {
		infowindow.open(map, marker);
	    });

	    infowindow.open(map, marker);

	}
    }
    function doSelectMenu() {
	var as = document.getElementsByTagName("a");
	for (var i = 0; i < as.length; i++) {
	    var a = as.item(i);
	    if (location.hostname == a.hostname && location.pathname.startsWith(a.pathname) && location.hash == a.hash) {
		if (a.search == '') {
		    selectLink(a);
		}

	    }
	}
    }
    function formatDate(date) {
	var day = date.getDate();
	var month = date.getMonth() + 1;
	var year = date.getFullYear();
	return (day < 10 ? '0' + day : day) + "/" + (month < 10 ? '0' + month : month) + "/" + year;
    }
    function formatDate2(date) {
	var day = date.getDate();
	var month = date.getMonth() + 1;
	var year = date.getFullYear();
	var tmp = (date.getDate() == 1 ? '1er' : date.getDate()) + ' ';
	tmp += " ";
	switch (date.getMonth()) {
	case 0:
	    tmp += "janvier";
	    break;
	case 1:
	    tmp += "février";
	    break;
	case 2:
	    tmp += "mars";
	    break;
	case 3:
	    tmp += "avril";
	    break;
	case 4:
	    tmp += "mai";
	    break;
	case 5:
	    tmp += "juin";
	    break;
	case 6:
	    tmp += "juillet";
	    break;
	case 7:
	    tmp += "août";
	    break;
	case 8:
	    tmp += "septembre";
	    break;
	case 9:
	    tmp += "octobre";
	    break;
	case 10:
	    tmp += "novembre";
	    break;
	case 11:
	    tmp += "décembre";
	    break;
	}

	tmp += " ";
	tmp += date.getFullYear();
	;

	return tmp;

    }

    function doCarrousel2() {
	var container = document.querySelector(".partenaires .listing");
	if (container != undefined && container != null) {
	    var items = container.querySelectorAll(".item");
	    if (items != undefined) {
		require([ "carrousel2" ], function(car) {
		    var carrousel = new car.Carrousel(container, items);
		    if (isMobileVersion()) {
			carrousel.itemCount = 2;
		    }
		    carrousel.start();
		});
	    }
	}
    }
    function doCarrousel() {
	var carrouselElt = document.querySelector(".carrousel .items");

	if (carrouselElt != undefined && carrouselElt != null) {
	    function initCarrouselItems(articles) {
		articles.forEach(function(article, idx) {
		    if (idx < 4) {
			var elt = document.querySelector(".carrousel .items .item:nth-child(" + (idx + 1) + ")");
			var infoElt = elt.querySelector(".info");
			if (article.publicationDate) {
			    infoElt.textContent = formatDate(article.publicationDate);
			}
			var titleElt = elt.querySelector(".title");
			if (article.title) {
			    titleElt.textContent = article.title;
			    titleElt.setAttribute("title", article.title);
			    titleElt.setAttribute("href", createArticlePageURL(article));
			    var linkElt = elt.querySelector(".link");
			    linkElt.setAttribute("href", createArticlePageURL(article));
			}
			var imgUrl = gedService.geCarrouselImageURL(article.id);
			var imgElt = elt.querySelector("img");
			var errorListener = function(e) {
			    e.target.removeEventListener("error", errorListener);
			    e.target.src = "/img/carrousel-image-defaut.jpg";
			}
			imgElt.addEventListener("error", errorListener);
			imgElt.src = imgUrl;

		    }
		});
	    }
	    gedService.getCarrouselItems(function(doc) {
		initCarrouselItems(doc);
		items = document.querySelectorAll(".carrousel .items .item");
		if (items != undefined) {
		    require([ "carrousel" ], function(car) {
			var carrousel = new car.Carrousel(items);

			var nextButtonElt = document.querySelector(".carrousel .nextButton");
			if (nextButtonElt != null) {
			    nextButtonElt.addEventListener("click", function(evt) {
				evt.preventDefault();
				carrousel.selectNext();
			    });
			}

			var prevButtonElt = document.querySelector(".carrousel .prevButton");
			if (prevButtonElt != null) {
			    prevButtonElt.addEventListener("click", function(evt) {
				evt.preventDefault();
				carrousel.selectPrevious();
			    });
			}

			carrousel.start();

		    });
		}
	    });
	}
    }

    function doZoom() {
	gedService.getZoomItems(function(items) {

	    var itemsElts = document.querySelectorAll(".zoom .listing .item");
	    if (itemsElts !== null && itemsElts !== undefined) {
		for (var i = 0; i < 2; i++) {
		    if (items.length > i) {
			var item = items[i];
			var itemElt = itemsElts.item(i);
			itemElt.setAttribute("href", item.url);
			itemElt.setAttribute("title", item.title);

			var imgElt = itemElt.querySelector("img");
			imgElt.setAttribute("src", item.img);

			var legendElt = itemElt.querySelector(".legend");
			legendElt.textContent = item.title;
		    }
		}
	    }
	});

    }
    function createArticlePageURL(gedArticle) {

	return "/article#" + gedArticle.id + "-" + encodeURIComponent(removeDiacritics(gedArticle.title).replace(/[\W]/g, "-").replace(/\s+/g, "-").replace(/-+/g, "-").replace(/-+$/g, '').replace(/^-+/g, '').toLowerCase());

    }
    function updateSelection() {
	// Query
	for (var i = 0; i < 2; i++) {
	    var searchInput = document.getElementById("SEARCH_INPUT_" + i);
	    searchInput.value = gedService.getCurrentParameters().getQuery();
	}

	// Type
	var gedTypeFilterButtons = document.querySelectorAll("a[data-ged-type]");
	if (gedTypeFilterButtons !== null && gedTypeFilterButtons !== undefined) {
	    for (var i = 0; i < gedTypeFilterButtons.length; i++) {
		var btn = gedTypeFilterButtons.item(i);
		if (parseInt(btn.getAttribute("data-ged-type")) === gedService.getCurrentParameters().getType()) {
		    btn.classList.add("selected");
		} else {
		    btn.classList.remove("selected");
		}
	    }
	}
	// Sections
	var gedSectionFilterButtons = document.querySelectorAll("#SECTIONS_CHOICE .item a");
	var selectedSectionElt = null;
	var selectedSectionId = 0;
	if (gedSectionFilterButtons !== null && gedSectionFilterButtons !== undefined) {
	    var currentSection = gedService.getCurrentParameters().getSection();
	    for (var i = 0; i < gedSectionFilterButtons.length; i++) {
		var btn = gedSectionFilterButtons.item(i);
		var p = gedService.readParametersFromHash(btn.hash);
		if (p.section === currentSection) {
		    btn.parentNode.classList.add("selected");
		    selectedSectionElt = btn;
		    selectedSectionId = p.section;
		} else {
		    btn.parentNode.classList.remove("selected");
		}
	    }
	}
	var currentSectionLabel = document.getElementById("CURRENT_SECTION_LABEL");
	if (selectedSectionId > 0) {
	    currentSectionLabel.textContent = selectedSectionElt.textContent;
	} else {
	    currentSectionLabel.textContent = '';
	}

	var currentSectionLink = document.getElementById("CURRENT_SECTION_LINK");
	if (selectedSectionId > 0) {
	    currentSectionLink.style.display = "block";
	    if (6 === gedService.getCurrentParameters().getType()) {
		currentSectionLink.classList.add("selected");
	    } else {
		currentSectionLink.classList.remove("selected");
	    }
	}

    }
    function doSwitchPanels() {
	var panelElts = document.querySelectorAll("div[data-switch-panel]");

	function initSwitch(panelElt) {
	    var switchElt = panelElt.querySelector("h3");
	    if (switchElt === null || switchElt === undefined) {
		switchElt = panelElt.querySelector("h4");
	    }
	    if (switchElt === null || switchElt === undefined) {
		switchElt = panelElt.querySelector("h5");
	    }
	    if (switchElt === null || switchElt === undefined) {
		switchElt = panelElt.querySelector(".title");
	    }
	    var contentElt = panelElt.querySelector("div");
	    switchElt.style.cursor = "pointer";
	    switchElt.addEventListener("click", function(e) {
		if (panelElt.classList.contains("selected")) {
		    panelElt.classList.remove("selected");
		} else {
		    panelElt.classList.add("selected");

		}
	    });
	}

	if (panelElts !== null && panelElts !== undefined) {
	    for (var i = 0; i < panelElts.length; i++) {
		var panelElt = panelElts[i];
		initSwitch(panelElt);

	    }

	}
    }
    function updateInstances(parameters) {
	function updateView(html) {
	    var tabsElt = document.querySelector(".main.articles .tabs");
	    tabsElt.style.display = '';
	    var containerElt = document.querySelector(".main.articles .listing");
	    containerElt.innerHTML = html;
	    doSwitchPanels();
	}
	var paggingElt = document.querySelector(".pagging");
	paggingElt.classList.add("hidden");
	gedService.getInstances(parameters.section, updateView);
	var paggingPageLinksElt = paggingElt.querySelector(".pageLinks");
	if (paggingPageLinksElt !== null && paggingPageLinksElt !== undefined) {
	    paggingPageLinksElt.innerHTML = "";
	}
	updateArticlesMetaTitle()
    }

    function updateExternalLinks(parameters) {
	if (parameters.section == 0) {
	    parameters.type = 1;
	    var currentSectionLink = document.getElementById("CURRENT_SECTION_LINK");
	    currentSectionLink.style.display = "none";
	    location.hash = '#' + parameters.createHash();
	}

	function updateView(html) {
	    var tabsElt = document.querySelector(".main.articles .tabs");
	    tabsElt.style.display = 'none';
	    var containerElt = document.querySelector(".main.articles .listing");
	    containerElt.innerHTML = html;
	}
	var paggingElt = document.querySelector(".pagging");
	paggingElt.classList.add("hidden");
	gedService.getExternalLinks(parameters.section, updateView);
	var paggingPageLinksElt = paggingElt.querySelector(".pageLinks");
	if (paggingPageLinksElt !== null && paggingPageLinksElt !== undefined) {
	    paggingPageLinksElt.innerHTML = "";
	}
	updateArticlesMetaTitle()
    }
    function updateArticlesMetaTitle() {
	gedService.getSections(function(sections) {
	    var currentParameters = gedService.getCurrentParameters();
	    var metaTitle = "";
	    switch (currentParameters.getType()) {
	    case 1:
		metaTitle += "Actualités";
		break;
	    case 2:
		metaTitle += "Communiqués";
		break;
	    case 3:
		metaTitle += "Publications";
		break;
	    case 4:
		metaTitle += "Multimédia";
		break;
	    case 5:
		metaTitle += "Instances";
		break;
	    case 6:
		metaTitle += "Liens sites externes";
		break;
	    }
	    for ( var g in sections) {
		for ( var k in sections[g]) {
		    var section = sections[g][k];
		    if (section.id == currentParameters.getSection()) {
			metaTitle += " - " + section.label;
		    }
		}
	    }
	    metaTitle += " - FEC FO";
	    var metaTitleElt = document.querySelector('head title');
	    metaTitleElt.textContent = metaTitle;
	    var ogTitleElt = document.querySelector("head meta[data-property='og:title']");
	    ogTitleElt.content = metaTitle;

	});
    }

    function updateArticles(parameters) {
	if (parameters.section == 0) {
	    var currentSectionLink = document.getElementById("CURRENT_SECTION_LINK");
	    currentSectionLink.style.display = "none";
	}
	function updateArticlesItemView(containerElt, gedArticle) {
	    var tabsElt = document.querySelector(".main.articles .tabs");
	    tabsElt.style.display = '';
	    var itemElt = document.createElement("div");
	    itemElt.classList.add("item");

	    var infoElt = document.createElement("div");
	    infoElt.classList.add("info");
	    itemElt.appendChild(infoElt);

	    var titleElt = document.createElement("a");
	    titleElt.classList.add("title");
	    itemElt.appendChild(titleElt);

	    var descriptionElt = document.createElement("div");
	    descriptionElt.classList.add("description");
	    itemElt.appendChild(descriptionElt);

	    var linkElt = document.createElement("a");
	    linkElt.classList.add("link");
	    linkElt.textContent = "Lire la suite";
	    itemElt.appendChild(linkElt);

	    var dateStr = formatDate(gedArticle.publicationDate);
	    var info = dateStr;
	    if (gedArticle.category !== null && gedArticle.category !== undefined) {
		info += " - " + gedArticle.category;
	    }
	    if (gedArticle.secteur !== null && gedArticle.secteur !== undefined) {
		info += " - " + gedArticle.secteur;
	    }

	    if (gedArticle.secteur2 !== null && gedArticle.secteur2 !== undefined) {
		info += " - " + gedArticle.secteur2;
	    }

	    infoElt.textContent = info;
	    titleElt.textContent = gedArticle.title
	    var url = createArticlePageURL(gedArticle);
	    titleElt.href = url;
	    descriptionElt.textContent = gedArticle.description;
	    linkElt.href = url;
	    containerElt.appendChild(itemElt);

	}
	function updateArticlesView(response, error) {

	    var containerElt = document.querySelector(".main.articles .listing");
	    var paggingPageLinksElt = document.querySelector(".pagging .pageLinks");
	    var prevLinkElt = document.querySelector(".pagging .prev");
	    prevLinkElt.classList.add("hidden");
	    var nextLinkElt = document.querySelector(".pagging .next");
	    nextLinkElt.classList.add("hidden");
	    containerElt.innerHTML = "";
	    paggingPageLinksElt.innerHTML = "";

	    if (error != undefined && error) {
		containerElt.innerHTML = '<p class="errorResult">Une erreur est survenue, veuillez-réessayer ultérieurement.</p>';
		return;
	    }

	    if (response !== null) {
		if (response.items.length == 0) {
		    containerElt.innerHTML = '<p class="emptyResult" >Aucune donnée n\'est référencée pour cette requête.</p>';

		} else {
		    for (var i = 0; i < response.items.length; i++) {
			updateArticlesItemView(containerElt, response.items[i]);
		    }
		}
	    }

	    if (paggingPageLinksElt !== null && paggingPageLinksElt !== undefined) {

		var pageCount = Math.floor(response.count / itemsPerPage);
		if (response.count % itemsPerPage != 0) {
		    pageCount++;
		}
		var currentPage = gedService.getCurrentParameters().getPage();
		var params = gedService.getCurrentParameters();
		if (pageCount > 1) {

		    var first = currentPage - 5;
		    if (first < 0) {
			first = 0;
		    }
		    var last = first + 10;
		    if (last > pageCount) {
			last = pageCount;
		    }
		    if (last - first < 10) {
			first = last - 10;
		    }
		    if (first < 0) {
			first = 0;
		    }
		    for (var i = first; i < last; i++) {
			var a = document.createElement("a");
			a.textContent = i + 1;
			params.setPage(i);
			a.setAttribute("href", "/#" + params.createHash());
			a.classList.add("link");
			if (currentPage == i) {
			    a.classList.add("selected");
			} else {
			    a.classList.remove("selected");
			}
			paggingPageLinksElt.appendChild(a);
		    }

		}

		if (currentPage == 0 || pageCount < 2) {
		    prevLinkElt.classList.add("hidden");
		} else {
		    prevLinkElt.classList.remove("hidden");
		    params.setPage(currentPage - 1);
		    prevLinkElt.setAttribute("href", "/#" + params.createHash());
		}

		if (currentPage == pageCount - 1 || pageCount < 2) {
		    nextLinkElt.classList.add("hidden");
		} else {
		    nextLinkElt.classList.remove("hidden");
		    params.setPage(currentPage + 1);
		    nextLinkElt.setAttribute("href", "/#" + params.createHash());
		}
	    }
	}

	updateArticlesMetaTitle();
	var itemsPerPage = 5;
	gedService.search(parameters, updateArticlesView);
    }

    function updateArticle(id) {
	function isVideo(a) {
	    return a.embedCode !== null || a.link.endsWith(".mp4");
	}
	function createPreviewElement(a) {
	    var previewElt = null;
	    if (a.link !== null) {
		if (a.link.endsWith(".pdf")) {
		    previewElt = document.createElement("iframe");
		    previewElt.src = a.link + "#zoom=75";
		    previewElt.scrolling = "no";
		    previewElt.classList.add("iframe-pdf");

		}
		if (a.link.endsWith(".mp4")) {
		    previewElt = document.createElement("video");
		    previewElt.src = a.link;
		    previewElt.setAttribute("controls", "controls");
		}

		if (a.link.endsWith(".jpg") || a.link.endsWith(".JPG")) {

		    previewElt = document.createElement("img");
		    previewElt.src = a.link;
		    previewElt.setAttribute("alt", a.title);
		}

	    } else {
		if (a.embedCode !== null) {
		    var div = document.createElement("div");
		    div.innerHTML = a.embedCode;
		    previewElt = div.firstChild;
		    previewElt.classList.add("iframe-video");
		}
	    }

	    return previewElt;
	}
	function updateTab(a) {
	    // Type
	    var gedTypeFilterButtons = document.querySelectorAll(".tabs a[data-ged-type]");
	    if (gedTypeFilterButtons !== null && gedTypeFilterButtons !== undefined) {
		for (var i = 0; i < gedTypeFilterButtons.length; i++) {
		    var btn = gedTypeFilterButtons.item(i);
		    if (parseInt(btn.getAttribute("data-ged-type")) === a.type) {
			btn.classList.add("selected");
		    } else {
			btn.classList.remove("selected");
		    }
		}
	    }
	}
	function updateArticleView(a) {

	    var mainElt = document.querySelector(".main");
	    if (a == null) {
		mainElt.style.display = "none";
		// FIXME
		location = '/';
	    } else {
		mainElt.style.display = "";
		updateTab(a);
		var linkElts = mainElt.querySelectorAll(".btn.pdf");
		for (var i = 0; i < linkElts.length; i++) {
		    linkElts.item(i).style.display = (a.link !== null && a.link.endsWith(".pdf")) ? "" : "none";
		    linkElts.item(i).href = a.link;
		    linkElts.item(i).download = a.title;
		}
		var infoElt = document.querySelector(".main .article .info");
		var dateStr = formatDate(a.publicationDate);
		var info = dateStr;
		if (a.category !== null && a.category !== undefined) {
		    info += " - " + a.category;
		}
		if (a.secteur !== null && a.secteur !== undefined) {
		    info += " - " + a.secteur;
		}

		if (a.secteur2 !== null && a.secteur2 !== undefined) {
		    info += " - " + a.secteur2;
		}
		infoElt.textContent = info;
		var metaTitleElt = document.querySelector("head title");
		var metaTitle = a.title + " - FECFO";
		metaTitleElt.textContent = metaTitle;
		var ogTitleElt = document.querySelector("head meta[data-property='og:title']");
		ogTitleElt.setAttribute("content", metaTitle);

		var ogURLElt = document.querySelector("head meta[data-property='og:url']");
		ogURLElt.setAttribute("content", createArticlePageURL(a));

		var metaTitleElt = document.querySelector("head meta[name='description']");
		metaTitleElt.setAttribute("content", info + " - " + a.title + " - Fédération employés & cadres");

		var titleElt = document.querySelector(".main .article .title");
		titleElt.textContent = a.title;
		var descriptionElt = document.querySelector(".main .article .description");
		descriptionElt.textContent = a.subTitle;
		var contentElt = document.querySelector(".main .article .content");
		contentElt.innerHTML = "";
		a.html = a.description;
		if (a.html != null) {
		    var htmlElt = document.createElement("div");
		    if (isVideo(a)) {
			var previewElt = createPreviewElement(a);
			if (previewElt != null) {
			    contentElt.appendChild(previewElt);
			}
		    }
		    var articleElt = document.createElement("article");
		    var vignetteContainerElt = document.createElement("div");
		    vignetteContainerElt.classList.add("vignette-wrap");
		    var vignetteElt = document.createElement("img");
		    vignetteElt.classList.add("vignette");
		    var ogImageElt = document.querySelector("head meta[data-property='og:image']");

		    var errorListener = function(e) {
			vignetteElt.removeEventListener("error", errorListener);
			vignetteElt.src = "/img/article-vignette.jpg";
			ogImageElt.setAttribute("content", vignetteElt.src);
		    };

		    vignetteElt.addEventListener("error", errorListener);
		    vignetteElt.src = gedService.geArticleImageURL(a.id);
		    ogImageElt.setAttribute("content", vignetteElt.src);
		    vignetteContainerElt.appendChild(vignetteElt);
		    articleElt.innerHTML = a.html;
		    articleElt.insertBefore(vignetteContainerElt, articleElt.firstChild);
		    contentElt.appendChild(articleElt);
		    contentElt.appendChild(htmlElt);
		} else {
		    var previewElt = createPreviewElement(a);
		    if (previewElt != null) {
			contentElt.appendChild(previewElt);
		    }
		}
		// Carousel
		loadCarrousel(contentElt);

	    }
	    function loadCarrousel(contentElt) {

		function readImage(url, successCallback, errorCallback) {
		    var imgElt = document.createElement("img");
		    var errorListener = function(e) {
			e.preventDefault();
			e.stopPropagation();
			imgElt.removeEventListener("error", errorListener);
			errorCallback(url);
		    };
		    var successListener = function(e) {
			imgElt.removeEventListener("load", errorListener);
			successCallback(url);

		    };
		    imgElt.addEventListener("error", errorListener);
		    imgElt.addEventListener("load", successListener);
		    imgElt.src = url;

		}

		function imageURL(baseURL, idx) {
		    return baseURL.replace(/(.*)\.(.*)$/, function(match, p1, p2) {
			return p1 + '_' + idx + '.' + p2
		    });
		}

		function readImages(baseURL, callback) {
		    var list = [];
		    var idx = 1;
		    function onError(url) {
			callback(list);
		    }
		    function onSuccess(url) {
			list.push(url);
			if (i < 10) {
			    readImage(imageURL(baseURL, idx++), onSuccess, onError);
			}
		    }
		    readImage(imageURL(baseURL, idx++), onSuccess, onError);
		}

		require([ "carrousel" ], function(m) {
		    var imagesList = [];
		    readImages(gedService.geArticleImageURL(a.id), function(imagesList) {
			if (imagesList.length > 0) {
			    var containerElt = document.createElement("div");
			    containerElt.classList.add("articleCarousel");
			    for (var i = 0; i < imagesList.length; i++) {
				var imgSrc = imagesList[i];
				var itemElt = document.createElement("div");
				var imgElt = document.createElement("img");
				imgElt.setAttribute("data-src", imagesList[i]);
				imgElt.setAttribute("src", imagesList[i]);
				itemElt.classList.add("item");
				itemElt.appendChild(imgElt);
				containerElt.appendChild(itemElt);

			    }

			    contentElt.appendChild(containerElt);

			    var carrousel = new m.Carrousel(containerElt.children);
			    carrousel.start();
			}
		    });

		});
	    }

	}
	gedService.lookup(id, updateArticleView);
    }
    function initGedTypeLinkAction() {
	var links = document.querySelectorAll("a[data-ged-type]");
	if (links !== null && links !== undefined) {
	    for (var i = 0; i < links.length; i++) {
		var link = links.item(i);
		var params = gedService.getCurrentParameters();
		params.setType(parseInt(link.getAttribute("data-ged-type")));
		params.setPage(0);
		link.setAttribute("href", "/#" + params.createHash());
	    }
	}
    }
    function initGedSectionLinkAction() {
	var menu = document.querySelector("#SECTIONS_CHOICE");

	if (!isMobileVersion()) {
	    menu.style.display = "none";
	    var mouseOverListener = function(evt) {
		evt.stopPropagation();
		evt.preventDefault();
		menu.style.display = '';
		removeEventListener("mouseover", mouseOverListener);
	    };
	    addEventListener("mouseover", mouseOverListener);
	}

	var links = menu.querySelectorAll(".item a");
	if (links !== null && links !== undefined) {
	    for (var i = 0; i < links.length; i++) {
		var link = links.item(i);
		var params = gedService.getCurrentParameters();
		var newParams = gedService.readParametersFromHash(link.hash);
		params.setSection(newParams.section);
		params.setPage(0);
		link.setAttribute("href", "/#" + params.createHash());
	    }
	}
    }

    addEventListener("hashchange", function() {
	updateHash();
    });

    function updateSearchForm() {
	// Query
	function submitSearch(query) {
	    var params = gedService.getCurrentParameters();
	    params.setQuery(query);
	    params.setPage(0);
	    var searchURL = "/" + (isMobileVersion() ? "?testMobile#" : "#") + params.createHash();
	    window.location = searchURL;
	}
	for (var i = 0; i < 2; i++) {
	    var searchInput = document.getElementById("SEARCH_INPUT_" + i);
	    searchInput.addEventListener("keydown", function(e) {
		if (e.keyCode === 13) {
		    e.preventDefault();
		    e.stopPropagation();
		    e.target.blur();
		    submitSearch(e.target.value);
		}
	    });
	    searchInput.addEventListener("focus", function(e) {
		this.classList.add("focus");
	    });
	    searchInput.addEventListener("blur", function(e) {
		this.classList.remove("focus");
	    });
	}

	var searchSubmit = document.getElementById("SEARCH_SUBMIT");
	searchSubmit.addEventListener("click", function(e) {
	    e.preventDefault();
	    e.stopPropagation();
	    var searchInput = document.getElementById("SEARCH_INPUT_1");
	    submitSearch(searchInput.value);
	});
    }

    function hideLoginEventListener(e) {
	switch (e.type) {
	case "mousedown":
	    hideLoginForm();
	    break;
	case "keyup":
	    if (e.keyCode == 27) {
		hideLoginForm();
	    }
	    break;
	}

    }
    function doPartnerSearch() {
	function updateArticlesItemView(containerElt, gedArticle) {

	    var itemElt = document.createElement("div");
	    itemElt.classList.add("item");

	    var infoElt = document.createElement("div");
	    infoElt.classList.add("info");
	    itemElt.appendChild(infoElt);

	    var titleElt = document.createElement("a");
	    titleElt.classList.add("title");
	    itemElt.appendChild(titleElt);

	    var descriptionElt = document.createElement("div");
	    descriptionElt.classList.add("description");
	    itemElt.appendChild(descriptionElt);

	    var linkElt = document.createElement("a");
	    linkElt.classList.add("link");
	    linkElt.textContent = "Lire la suite";
	    itemElt.appendChild(linkElt);

	    var pubDate = new Date(gedArticle.publicationDate);
	    var dateStr = formatDate2(pubDate);
	    infoElt.textContent = dateStr;
	    titleElt.textContent = gedArticle.title
	    var url = createArticlePageURL(gedArticle);
	    titleElt.href = url;
	    descriptionElt.textContent = gedArticle.description;
	    linkElt.href = url;
	    containerElt.appendChild(itemElt);

	}
	function updateArticlesView(response) {
	    var articlesElt = document.querySelector("#articles");
	    var containerElt = articlesElt.querySelector(".listing");
	    containerElt.innerHTML = "";
	    if (response !== null) {
		if (response.items.length > 0) {
		    articlesElt.classList.remove("hidden");
		    for (var i = 0; i < response.items.length; i++) {
			updateArticlesItemView(containerElt, response.items[i]);
		    }
		    if (response.items.length > 5) {
			var a = document.createElement('a');
			a.href = "";
		    }
		} else {
		    articlesElt.classList.add("hidden");
		}

	    }
	}
	try {
	    var p = JSON.parse(document.body.getAttribute("data-page-parameters"));
	    if ("query" in p) {
		var params = new ged.GEDParameters();
		gedService.search(params, updateArticlesView, {
		    "doc_dpa_202_300" : p.query,
		    "rcs" : 25
		});
	    }

	} catch (e) {
	    // console.error(e);
	}
    }
    function displayLoginForm() {
	var loginForm = document.querySelector(".login form");
	loginForm.parentNode.style.display = "block";
	loginForm.elements['login'].focus();
	loginForm.parentNode.addEventListener("mousedown", function(e) {
	    e.stopPropagation();
	});
	addEventListener("keyup", hideLoginEventListener);
	addEventListener("mousedown", hideLoginEventListener);
    }
    function hideLoginForm() {
	removeEventListener("keyup", hideLoginEventListener);
	removeEventListener("mousedown", hideLoginEventListener);
	var loginForm = document.querySelector(".login form");
	loginForm.parentNode.style.display = "";
    }

    function doLoginForm() {
	var switchInput = document.querySelector(".login .switch");
	switchInput.addEventListener("focus", displayLoginForm);
	var loginForm = document.querySelector(".login form");
	loginForm.addEventListener("submit", function(evt) {
	    evt.preventDefault();
	    evt.stopPropagation();
	    if (this.action == '' || this.action == location.href) {
		var login = this.elements['login'].value;
		var password = this.elements['password'].value;
		var authenticated = gedService.login('fec', login, password, function(xml) {
		    var msgElt = xml.getElementsByTagName("msg").item(0);
		    if (msgElt.textContent === 'CNX') {
			loginForm.reset();
			this.parentNode.style.display = "";
			var usv = xml.getElementsByTagName("usv").item(0).textContent;
			var url = gedService.createGEDUrl(usv)
			this.action = url;

			this.submit();
		    } else {
			alert("Erreur! Veuillez vérifier l'identifiant et le mot de passe.");
			this.reset();
			this.elements['login'].focus();
		    }
		}.bind(this), function() {
		    alert("Erreur! Veuillez vérifier l'identifiant et le mot de passe.");
		    this.reset();
		    this.elements['login'].focus();
		}.bind(this));
	    }
	});
    }

    function updateHash() {
	// window.scrollTo(0, 0);

	if (location.pathname == '/') {
	    gedService.loadParametersFromHash(location.hash);
	    initGedTypeLinkAction();
	    initGedSectionLinkAction();
	    updateSelection();
	    switch (gedService.getCurrentParameters().type) {
	    case 5:
		updateInstances(gedService.getCurrentParameters());

		break;
	    case 6:
		updateExternalLinks(gedService.getCurrentParameters());
		break;
	    default:
		updateArticles(gedService.getCurrentParameters());
	    }

	} else {
	    doSelectMenu();
	}

	if (location.pathname == '/article') {
	    initGedTypeLinkAction();
	    updateArticle(gedService.readArticleIdFromHash(location.hash));

	}

    }
    function isMobileVersion() {
	return document.body.offsetWidth < 1000
	// ||
	// return location.search == '?testMobile';
    }
    function onDOMContentLoaded() {
	// Mobile

	if (isMobileVersion()) {
	    require([ "mobile-ui" ], function(m) {
		var ui = m.MobileUI.getInstance();
		ui.init(window);
	    });
	    var elts = document.querySelectorAll('footer *[data-switch-panel]');
	    for (var i = 0; i < elts.length; i++) {
		elts[i].classList.remove("selected");
	    }

	    /*
	     * var searchBtn=document.querySelector("header .searchBtn");
	     * searchBtn.addEventListener("mouseup",function(){ var
	     * searchInput=document.querySelector("header .search input");
	     * if(searchInput.classList.contains("focus")){
	     * searchInput.classList.remove("focus"); searchInput.blur(); }else{
	     * searchInput.classList.add("focus"); searchInput.focus(); }
	     * 
	     * });
	     */
	}

	doLoginForm();
	// External Link set target to "_BLANK"
	addEventListener("mousedown", function(e) {
	    var elt = e.target;
	    while (elt != null && elt != undefined) {
		if (elt.nodeName == 'a' || elt.nodeName == 'A') {
		    var a = elt;
		    if (a.hostname != location.hostname) {
			a.setAttribute("target", "_BLANK");
		    }
		    break;
		}
		elt = elt.parentNode;
	    }
	});

	RequestHelper.doRequestsResult();
	doSelectMenu();

	updateSearchForm();
	doCarrousel();
	doCarrousel2();

	require([ "extra" ], function(extra) {
	    extra.exec();
	});
	doMap();
	doSocialLinks();
	doPartnerSearch();
	doSwitchPanels();
	updateHash();

    }

    addEventListener("DOMContentLoaded", onDOMContentLoaded);

    // FIX MOBILE
    // if (location.search == '?testMobile') {
    // var elt = document.querySelector('head link[href="/css/style.css"]');
    // if (elt !== undefined && elt !== null) {
    // elt.href = "/css/style-mobile.css.php";
    // }
    // addEventListener("mousedown", function(evt) {
    // console.log("mouse down");
    // var target = evt.target;
    //
    // while (target !== null && target !== undefined && target.href ===
    // undefined) {
    // target = target.parentNode;
    // }
    // if (target !== null && target !== undefined) {
    // if (target.href !== '') {
    // var href = target.href;
    // var url = new URL(target.href);
    // url.search = '?testMobile';
    // target.href = url;
    // }
    // } else {
    // // console.log("ERROR");
    // }
    //
    // });
    //
    // }

    if (document.readyState != "loading") {
	onDOMContentLoaded();
    }

});