<?php 

//dependencies
require_once '../../../../configuration/config.inc.php';
session_start();
require_once 'web/package.inc.php';
require_once 'profile/package.inc.php';

if(!ServiceRequestUtils::checkAuthorization('MANAGE_PROFILE')){
	exit(0);
}

$requestCode="UPDATE_PERSON_PROFILE";
$result=new JavaScriptRequestResultWrapper(array('name','firstname','email',
		'phone','mobile'));

$httpRequest=new HttpRequest();

$error=false;
if($httpRequest->hasPostData("profile-id")){
	$personId=$httpRequest->getPostDataAsInteger("profile-id");
}
$person=new PersonProfile($personId);
if($httpRequest->hasPostData("firstname")){
	$person->setFirstName($httpRequest->getPostDataAsText("firstname"));
}else{
	$result->message.='Le champ "Prénom" n\'est pas rempli.';
	$error=true;
}
if($httpRequest->hasPostData("name")){

	$person->setName($httpRequest->getPostDataAsText("name"));

}else{

	$result->message.='Le champ "Nom" n\'est pas rempli.';

	$error=true;

}
if($httpRequest->hasPostData("email")){

	$person->setEmail($httpRequest->getPostDataAsText("email"));

}else{

	$result->message.='Le champ "Email" n\'est pas rempli.';

	$error=true;

}
if($httpRequest->hasPostData("phone")){

	$person->setPhone($httpRequest->getPostDataAsText("phone"));

}else{

	$result->message.='Le champ "Téléphone" n\'est pas rempli.';

	$error=true;

}if($httpRequest->hasPostData("mobile")){
	$person->setMobile($httpRequest->getPostDataAsText("mobile"));
}
if(!$error){
	try{
		$service=new ProfileService(getWebControllerDB());
		$service->updatePersonProfile($person);
		$result->message="Les changements ont bien été pris en compte";
		$result->done=true;
	}catch(ServiceFunctionalException $e){
		$result->message=$e->getFunctionalError()->getMessage();
	}catch(Exception $e){
		$result->message="Une erreur est survenue lors de la mise à jour de l'adresse";
		error_log("EXCEPTION ...".$e->getMessage());
	}
}
ServiceRequestUtils::setRequestResult($requestCode, $result);
?>