<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
use xo\message\MessageService;
session_start ();

if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_MESSAGE' )) {
	exit ( 0 );
}

$requestCode = "UPDATE_MESSSAGE_CONFIG";
$result = new JavaScriptRequestResultWrapper ( array () );

$httpRequest = new HttpRequest ();

$error = false;
$id = null;
if ($httpRequest->hasPostData ( "id" )) {
	$id = $httpRequest->getPostDataAsInteger ( "id" );
}

if ($httpRequest->hasPostData ( "from" )) {
	$from = $httpRequest->getPostDataAsText ( "from" );
} else {
	$result->message .= 'Le champ "Email d\'envoi" n\'est pas rempli.';
	$error = true;
}
if ($httpRequest->hasPostData ( "sender" )) {
	$sender = $httpRequest->getPostDataAsText ( "sender" );
} else {
	$sender = $from;
}
if ($httpRequest->hasPostData ( "subject" )) {
	$subject = $httpRequest->getPostDataAsText ( "subject" );
} else {
	$result->message .= 'Le champ "Titre de l\'email" n\'est pas rempli.';
	$error = true;
}
if ($httpRequest->hasPostData ( "cc" )) {
	$cc = $httpRequest->getPostDataAsText ( "cc" );
} else {
	$cc = "";
}
if ($httpRequest->hasPostData ( "bcc" )) {
	$bcc = $httpRequest->getPostDataAsText ( "bcc" );
} else {
	$bcc = "";
}

if (! $error) {
	try {
		$service = new MessageService ( Configuration::getInstance ()->db () );
		$service->updateConfiguration ( $id, $from, $sender, $subject, $cc, $bcc );
		$result->message = "Le contenu a bien été modifié";
		$result->done = true;
	} catch ( ServiceFunctionalException $e ) {
		$result->message = $e->getFunctionalError ()->getMessage ();
	} catch ( Exception $e ) {
		$result->message = "Une erreur est survenue lors de la modification du contenu";
		error_log ( "EXCEPTION ..." . $e->getMessage () );
	}
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?>