<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\cms\ResourceRenderer;
use xo\cms\WebPage;
use xo\cms\WebPageRenderer;
use xo\content\ContentService;
use xo\www\HttpRequest;
$httpRequest = new HttpRequest ();
if ($httpRequest->hasGetData ( "id" )) {
	$idStr = $httpRequest->getGetDataAsText ( "id" );
	$idBin = hex2bin ( $idStr );
	$contentService = new ContentService ( Configuration::getInstance () );
	$resource = $contentService->getCurrentResource ( $idBin );
	if ($resource != null) {
		if ($resource instanceof WebPage) {
			header ( "Content-Type:text/html;charset=UTF-8" );
			$renderer = new WebPageRenderer ();
		} else {
			$md5 = base64_encode ( $resource->data->md5 );
			$date = gmdate ( "D, d M Y H:i:s", $resource->data->date ) . " GMT";
			header ( "Date:$date" );
			header ( "Content-Type:{$resource->data->contentType}" );
			header ( "Content-Encoding:{$resource->data->encoding}" );
			header ( "Content-Disposition:inline; filename={$resource->data->filename}" );
			header ( "Content-MD5:$md5" );
			$renderer = new ResourceRenderer ( $contentService );
		}
		$out = fopen ( "php://output", 'r+' );
		$renderer->render ( $out, $resource );
	} else {
		header ( "Status: 404 Not Found", false, 404 );
	}
} else {
	header ( "Status: 404 Not Found", false, 404 );
}
?>