<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\content\ContentService;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}

// check authorization
// read dto
$requestCode = "UPDATE_WEBPAGE_FORM";
$result = new JavaScriptRequestResultWrapper ( array (
		"template",
		"parameters" 
) );
$result->message = "";
$error = false;
$httpRequest = new HttpRequest ();

$id = null;
$template = null;
$parameters = null;
$contentService = new ContentService ( Configuration::getInstance () );
$resource = null;
if ($httpRequest->hasPostData ( "id" )) {
	$idStr = $httpRequest->getPostDataAsText ( "id" );
	$id = hex2bin ( $idStr );
	$resource = $contentService->getResource ( $id );
	if ($resource == null) {
		$error = true;
		$result->message .= 'Aucune ressource ne correspond à l\'identifiant : $idStr.';
	}
} else {
	$error = true;
	$result->message .= 'Le champ "Identifiant" n\'est pas rempli.';
}
if ($httpRequest->hasPostData ( "parameters" )) {
	$parameters = $httpRequest->getPostDataAsText ( "parameters" );
}
if ($httpRequest->hasPostData ( "template" )) {
	$template = $httpRequest->getPostDataAsText ( "template" );
}


if (! $error) {
	$resource->templateName = $template;
	$resource->parameters = $parameters;
	$resource = $contentService->updateWebPage ( $resource );
	$result->done = true;
	$result->message = "L'opération s'est bien déroulée.";
} else {
	echo "ERROR";
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?> 