<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\content\ContentService;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}

$requestCode = "UPDATE_RESOURCEREF_FORM";
$result = new JavaScriptRequestResultWrapper ( array (
		"url",
		"resourceId" 
) );
$result->message = "";
$error = false;
$contentService = new ContentService ( Configuration::getInstance () );

$httpRequest = new HttpRequest ();
$resourceRef = null;
$id = null;
$comment = null;
$description = null;
$label = null;
$title = null;
$img = null;
$imgAlt = null;
$imgOver = null;

if ($httpRequest->hasPostData ( "id" )) {
	$idStr = $httpRequest->getPostDataAsText ( "id" );
	$id = hex2bin ( $idStr );
	$resourceRef = $contentService->getResourceRef ( $id );
	if ($resourceRef == null) {
		$error = true;
		$result->message .= 'Aucun lien ne correspond à l\'identifiant : $idStr.';
	}
} else {
	$error = true;
	$result->message .= 'Le champ  "Identifiant" doit être rempli.';
}
if ($httpRequest->hasPostData ( "comment" )) {
	$comment = $httpRequest->getPostDataAsText ( "comment" );
}
if ($httpRequest->hasPostData ( "description" )) {
	$description = $httpRequest->getPostDataAsHTML( "description" );
}
if ($httpRequest->hasPostData ( "label" )) {
	$label = $httpRequest->getPostDataAsText ( "label" );
}
if ($httpRequest->hasPostData ( "title" )) {
	$title = $httpRequest->getPostDataAsText ( "title" );
}
if ($httpRequest->hasPostData ( "imgId" )) {
	if ($httpRequest->hasPostData ( "imgAlt" )) {
		$imgAlt = $httpRequest->getPostDataAsText ( "imgAlt" );
		$imgId = $httpRequest->getPostDataAsText ( "imgId" );
		$img = $contentService->getResource ( hex2bin ( $imgId ) );
		if ($img == null) {
			$error = true;
			$result->message .= 'Aucune ressource ne correspond à l\'identifiant : $imgId.';
		} else {
			if ($httpRequest->hasPostData ( "imgOverId" )) {
				$imgOverId = $httpRequest->getPostDataAsText ( "imgOverId" );
				$imgOver = $contentService->getResource ( hex2bin ( $imgOverId ) );
				if ($imgOver == null) {
					$error = true;
					$result->message .= 'Aucune ressource ne correspond à l\'identifiant : $imgOverId.';
				}
			}
		}
	} else {
		$error = true;
		$result->message .= 'Le champ  "Image Alt" doit être rempli.';
	}
}

if (! $error) {
	$resourceRef->comment = $comment;
	$resourceRef->description = $description;
	$resourceRef->label = $label;
	$resourceRef->title = $title;
	$resourceRef->img = $img;
	$resourceRef->imgAlt = $imgAlt;
	$resourceRef->imgOver = $imgOver;
	$contentService->updateResourceRef ( $resourceRef );
	$result->done = true;
	$result->message = "L'opération s'est bien déroulée.";
} else {
	echo "ERROR";
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?> 