<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\content\ContentService;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}

$requestCode = "UPDATE_RESOURCEREF_TARGET_FORM";
$result = new JavaScriptRequestResultWrapper ( array (
		"url",
		"resourceId" 
) );
$result->message = "";
$error = false;
$contentService = new ContentService ( Configuration::getInstance () );

$httpRequest = new HttpRequest ();

$resourceRef=null;
$id = null;
$url = null;
$resourceId = null;

if ($httpRequest->hasPostData ( "id" )) {
	$idStr = $httpRequest->getPostDataAsText ( "id" );
	$requestCode .= strtoupper ( $idStr );
	$id = hex2bin ( $idStr );
	$resourceRef = $contentService->getResourceRef ( $id );
	if ($resourceRef == null) {
		$error = true;
		$result->message .= 'Aucun lien ne correspond à l\'identifiant : $idStr.';
	}
}
if ($httpRequest->hasPostData ( "url" )) {
	$url = $httpRequest->getPostDataAsText ( "url" );
}
var_dump($_POST);
if ($httpRequest->hasPostData ( "resourceId" )) {
	$resourceId = $httpRequest->getPostDataAsText ( "resourceId" );
	
	
	
	$resource = $contentService->getResource ( hex2bin ( $resourceId ) );
	if ($resource == null) {
		$error = true;
		$result->message .= 'Aucune ressource ne correspond à l\'identifiant : $resourceId.';
	}
}
if ($resourceId == null && $url == null) {
	$error = true;
	$result->message .= 'Un des champs "URL ou Ressource" doit être rempli.';
}



if (! $error) {
	if ($url != null) {
		$resourceRef->url = $url;
		$resourceRef->path = null;
	} else {
	    $resourceRef->url = null ;
	    $resourceRef->path =$resource->path;
	}
	$contentService->updateResourceRef ( $resourceRef );
	$result->done = true;
	$result->message = "L'opération s'est bien déroulée.";
} else {
	echo "ERROR";
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );
?> 