<?php
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\content\ContentService;
use xo\www\HttpRequest;
$httpRequest = new HttpRequest ();
if ($httpRequest->hasGetData ( "id" )) {
	$idStr = $httpRequest->getGetDataAsText ( "id" );
	$idBin = hex2bin ( $idStr );
	$contentService = new ContentService ( Configuration::getInstance () );
	$data = $contentService->getData ( $idBin );
	if ($data != null) {
		$md5 = base64_encode ( $data->md5 );
		$date = gmdate ( "D, d M Y H:i:s", $data->date ) . " GMT";
		header ( "Date:$date" );
		$expire = gmdate ( "D, d M Y H:i:s", $data->date+(3600 * 24 * 90)) . " GMT";
		header ( "Expires:$expire" );
		header ( "Content-Type:{$data->contentType}" );
		header ( "Content-Encoding:{$data->encoding}" );
		header ( "Content-Disposition: inline; filename={$data->filename}" );
		header ( "Content-MD5:$md5" );
		header ( "Content-Length:{$data->length}" );
		$out = fopen ( "php://output", 'r+' );
		$contentService->writeResourceData ( $out, $data );
	} else {
		header ( "Status: 404 Not Found", false, 404 );
	}
} else {
	header ( "Status: 404 Not Found", false, 404 );
}
?>