<?php
// dependencies
require_once '../../../../configuration/config.inc.php';
use xo\access\AccessService;
use xo\cms\core\Configuration;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_ACCESS' )) {
	
	exit ( 0 );
}

$result = new JavaScriptRequestResultWrapper ( array () );
$result->hideInfoMessage = false;

$requestCode = "GENERATE_ACCESS_PASSWORD";

$login = null;
$password = null;

$httpRequest = new HttpRequest ();
if ($httpRequest->hasPostData ( 'access-id' )) {
	
	$accessId = $httpRequest->getPostDataAsInteger ( 'access-id' );
}

try {
	$accessService = new AccessService ( Configuration::getInstance ()->db () );
	$password = $accessService->generateRandomPassword ();
	$accessService->updateAccessPassword ( $accessId, $password );
	$result->message = "Un nouveau mot de passe a été généré : $password";
	
	$result->done = true;
} catch ( ServiceFunctionalException $e ) {
	$result->message = $e->getFunctionalError ()->getMessage ();
}
ServiceRequestUtils::setRequestResult ( $requestCode, $result );

?>