<?php 
//dependencies 
require_once '../../../../configuration/config.inc.php';
use xo\access\AccessService;
use xo\cms\core\Configuration;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start();
if(!ServiceRequestUtils::checkAuthorization('MANAGE_ACCESS')){
	exit(0);
}

$requestCode="CREATE_ACCESS";
$result=new JavaScriptRequestResultWrapper(array('login','email','generate-password'));
$result->hideInfoMessage=false;
$login=null;
$email=null;
$password1=null;
$password2=null;
$generatePassword=null;

$httpRequest=new HttpRequest();
if($httpRequest->hasPostData('login')){
	$login=$httpRequest->getPostDataAsText("login");
}
if($httpRequest->hasPostData('email')){

	$email=$httpRequest->getPostDataAsText("email");

}
if($httpRequest->hasPostData('generate-password')){

	$generatePassword=$httpRequest->getPostDataAsText("generate-password");

}
$generatePassword=$generatePassword=='true';
if($httpRequest->hasPostData('password1')){

	$password1=$httpRequest->getPostDataAsText("password1");

}
if($httpRequest->hasPostData('password2')){

	$password2=$httpRequest->getPostDataAsText("password2");

}

$db=Configuration::getInstance()->db();
$accessService=new AccessService($db);

if($generatePassword){
	$password1=$password2=$accessService->generateRandomPassword();
}
if(empty($password1)){
	$result->message="Le mot de passe doit être précisé";
}else{
	if($password1 != $password2){

		$result->message="Les 2 mots de passe ne correspondent pas";

	}else{

		try{
			$accessId=$accessService->createAccess($email,$login,$password1);
			$result->message="L'accès a bien été créé";
			if($generatePassword){
				$result->message.=" -  Mot de passe : $password1";
			}
			$result->done=true;
		}catch(ServiceFunctionalException $e){
			$result->message=$e->getFunctionalError()->getMessage();
		}

	}
}

ServiceRequestUtils::setRequestResult($requestCode, $result);

?>