<?php
// dependencies
require_once '../../../../configuration/config.inc.php';
use xo\access\AccessService;
use xo\cms\core\Configuration;
use xo\www\HttpRequest;
use xo\www\JavaScriptRequestResultWrapper;
use xo\www\ServiceRequestUtils;
session_start ();

if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_ACCESS' )) {
	exit ( 0 );
}

$requestCode = "CHECK_ACCESS";
$result = new JavaScriptRequestResultWrapper ( array (
		'login' 
) );

$login = null;
$password = null;
$error = false;
$httpRequest = new HttpRequest ();
if ($httpRequest->hasPostData ( 'login' )) {
	$login = $httpRequest->getPostDataAsText ( "login" );
} else {
	$error = true;
	$result->message .= "Aucun login n'a été entré. ";
}

if ($httpRequest->hasPostData ( 'password' )) {
	
	$password = $httpRequest->getPostDataAsText ( "password" );
} else {
	$error = true;
	$result->message .= "Aucun mot de passe n'a été entré. ";
}

try {
	if (! $error) {
		
		$accessService = new AccessService ( Configuration::getInstance ()->db () );
		$access = $accessService->login ( $login, $password );
		if ($access == null) {
			$result->message = "Le login et le mot de passe ne correspondent pas";
		} else {
			$result->message = "Le login et le mot de passe correspondent";
			
			$result->done = true;
		}
	}
} catch ( ServiceFunctionalException $e ) {
	$result->message = $e->getFunctionalError ()->getMessage ();
}

ServiceRequestUtils::setRequestResult ( $requestCode, $result );

?>