<?php
require_once '../../../../configuration/config.inc.php';
use xo\message\MessageService;
use xo\cms\core\Configuration;
use xo\www\ServiceRequestUtils;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_MESSAGE', false )) {
	exit ( 0 );
}
if (! array_key_exists ( "type", $_GET )) {
	exit ( 0 );
}
$typeCode = $_GET ['type'];
$title = 'Administration - Messages';
$messagesService = new MessageService ( Configuration::getInstance ()->db () );

$messages = $messagesService->getMessagesByTypeCode ( $typeCode );
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
        <?php include '../../html-headers.tpl.php'; ?>
        <link href="/style/message/messages-by-type.css" media="all" rel="stylesheet" type="text/css" />
</head>
<body>
	<div id="BODY">
		<?php include '../../menu.tpl.php'; ?>
		<h1>
			<?=$title?>
		</h1>
		<?php 
		
		$message=null;
		include '../menu.tpl.php'; 
		?>
		<fieldset>
			<legend>Messages</legend>
		<?php if(count($messages)>0){?>
		 <table>
				<tr>
					<th>Date :</th>
					<th>Email :</th>
					<th>Titre</th>
				</tr>
		<?php  foreach ($messages as $message) { ?>
           <tr>
					<td><?=$message->date?></td>
					<td><?=$message->email?></td>
					<td><?=$message->title?></td>
					<td><a href="/modules/message/message?id=<?=$message->id?>">lire le message</a></td>
				</tr>
         <?php } ?>
         </table>        
		
		<?php }else{ ?>
		<div>Aucun message</div>
		 <?php } ?>
		 
		 </fieldset>
	</div>

</body>
</html>
