<?php
// dependencies
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\content\ContentService;
use xo\www\ServiceRequestUtils;
use xo\cms\Pagging;
use xo\www\HttpRequest;
session_start ();

if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}
$title = 'Administration - Contenu - Gestion des pages web';
$service = new ContentService ( Configuration::getInstance () );
$limit = 20;
$resourcesCount = $service->getWebPagesCount ();
$pagging = new Pagging ( $resourcesCount, $limit );
$httpRequest = new HttpRequest ();
if ($httpRequest->hasGetData ( "p" )) {
	$currentPage = $httpRequest->getGetDataAsInteger ( "p" );
	if ($currentPage < 0) {
	} elseif ($currentPage > $pagging->lastPage ()) {
		header ( "Status: 301 Moved Permanently", false, 301 );
		header ( "Location: ?p={$pagging->lastPage ()}" );
		exit ();
	} else {
		$pagging->setPage ( $currentPage );
	}
} else {
	$pagging->setPage ( 0 );
}
$resources = $service->getWebPages ( $pagging->offset (), $limit );

?>
<!DOCTYPE html>
<html>
<head>
<?php include '../../html-headers.tpl.php'; ?>
<link type="text/css" href="/style/content/webpages.css" rel="stylesheet" />
<script type="text/javascript">
function select(id){
	opener.dispatchEvent( new CustomEvent("select",{
				detail: {
					message: id,
					time: new Date(),
				},
				bubbles: true,
				cancelable: true
			}
		));
	close();
}
</script>
</head>
<body>
	<div id="BODY">
		<?php include '../../menu.tpl.php'; ?>
		<h1><?=$title?></h1>
		<?php include '../menu.tpl.php'; ?>
		<fieldset>
			<legend><?=$resourcesCount?> page(s) - page <?=$pagging->page+1?> / <?=$pagging->lastPage()+1?>  </legend>
			<table>
				<thead>
					<tr>
						
						<th>Nom</th>
						<th>Chemin</th>
						<th>Template</th>
						<th>Version</th>
					</tr>
				</thead>
				<tbody>
				<?php foreach ($resources as $resource){?>
					<tr>
					<td><?=htmlentities($resource->name)?></td>
						<td><a target="_BLANK" <?= $resource->path->online?'class="online"':'class="offline"' ?> href="<?=$resource->path->path?>"><?=$resource->path->path?></a></td>
						<td><?= htmlentities($resource->templateName) ?></td>
						<td><?=htmlentities($resource->version)?></td>
						<td><button onclick="select('<?=bin2hex($resource->id)?>')">Choisir</button></td>
					</tr>
				<?php }?>
				</tbody>
			</table>
			<?php if($pagging->lastPage()>0){?>
			<div class="pagging">
		<?php if($pagging->previousPage !==null){?>
		<a href="?p=<?=$pagging->previousPage?>">&lt;</a>
		<?php }?>
		<?php foreach($pagging->pages as $page){ ?>
		<span class="pageLinks"><a <?=$page==$pagging->page?'class="selected"':'' ?> href="?p=<?=$page?>"><?=$page?></a></span>
		<?php }?>
		<?php if($pagging->nextPage!==null){?>
		<a href="?p=<?=$pagging->nextPage?>">&gt;</a>
		<?php }?>
			</div>
		<?php }?>
		</fieldset>
		<fieldset>
			<legend>Créer une nouvelle page</legend>
			<form id="CREATE_WEBPAGE_FORM" method="POST" enctype="multipart/form-data" action="/system/service/content/create-webpage.php">
				<fieldset>
					<div>
						<label>Nom :</label> <input required="required" name="name" type="text" />
					</div>
					<div>
						<label>Chemin :</label> <input name="path" required="required" placeholder="/le/chemin/voulu.txt" name="path" type="text" pattern="[/|(/[a-z0-9-\.]+)+]" />
					</div>
					<div>
						<label>Template : </label> <input required="required" name="template" value="default" type="text" />
					</div>
				</fieldset>
				<div>
					<input type="submit" value="Créer" />
				</div>
			</form>
		</fieldset>
	</div>
</body>
</html>
