<?php
// dependencies
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\cms\Pagging;
use xo\content\ContentService;
use xo\www\ServiceRequestUtils;
use xo\www\HttpRequest;
session_start ();

if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}
$title = 'Administration - Contenu - Gestion des ressources';
$service = new ContentService ( Configuration::getInstance () );

$limit = 7;

$httpRequest = new HttpRequest ();
$mimeType = null;
$contentTypes = $service->getContentTypes ();
$currentPage = 0;

if ($httpRequest->hasGetData ( "p" )) {
	$currentPage = $httpRequest->getGetDataAsInteger ( "p" );
}

if ($httpRequest->hasGetData ( "ct" )) {
	$mimeType = $httpRequest->getGetDataAsText ( "ct" );
	
	foreach ( $contentTypes as $type ) {
		if ($mimeType == $type ['label']) {
			$resourcesCount = $type ['count'];
		}
	}
	$pagging = new Pagging ( $resourcesCount, $limit );
	$pagging->setPage ( $currentPage );
} else {
	$resourcesCount = $service->getResourcesCount ();
	$pagging = new Pagging ( $resourcesCount, $limit );
	$pagging->setPage ( $currentPage );
}

if ($currentPage < 0) {
} elseif ($currentPage > $pagging->lastPage ()) {
	header ( "Status: 301 Moved Permanently", false, 301 );
	header ( "Location: ?p={$pagging->lastPage ()}" );
	exit ();
} else {
	if ($mimeType !== null) {
		$resources = $service->filterResourcesByContentType ( $mimeType, $pagging->offset (), $limit );
	} else {
		$resources = $service->getResources ( $pagging->offset (), $limit );
	}
}
?>
<!DOCTYPE html>
<html>
<head>
<?php include '../../html-headers.tpl.php'; ?>
<link type="text/css" href="/style/content/resources.css" rel="stylesheet" />
</head>
<body>
	<div id="BODY">
		<?php include '../../menu.tpl.php'; ?>
		<h1><?=$title?></h1>
		<?php include '../menu.tpl.php'; ?>
		<fieldset>
			<legend><?=$resourcesCount?> ressource(s) - page <?=$pagging->page+1?> / <?=$pagging->lastPage()+1?>  </legend>
			<div>
				<form method="GET" id="FILTER_FORM" >
					<label>Type : </label> <select name="ct" onchange="document.getElementById('FILTER_FORM').submit()">
						<option value="">-----------------</option>
					<?php foreach($contentTypes as $type){?>
					<option <?=$mimeType==$type['label']?'selected="selected"':''?> value="<?=$type['label']?>"><?=$type['label']?>&nbsp;(<?=$type['count']?>)</option>
					<?php }?>
				</select> <input type="hidden" name="p" value="0" />
				</form>
			</div>
			<table>
				<thead>
					<tr>
						<th>Icône</th>
						<th>Nom</th>
						<th>Chemin</th>
						<th>Version</th>
						<th></th>
					</tr>
				</thead>
				<tbody>
				<?php foreach ($resources as $resource){ ?>
						<tr>
						<td><img src="/system/service/content/preview-resource.php?id=<?=bin2hex($resource->id)?>" alt="Preview" /></td>
						<td><?=htmlentities($resource->name)?></td>
						<td><a target="_BLANK" <?= $resource->path->online?'class="online"':'class="offline"' ?> href="<?=$resource->path->path?>"><?=$resource->path->path?></a></td>
						<td><?=htmlentities($resource->version)?></td>
						<td><form action="/modules/content/resource" method="GET">
								<input type="hidden" value="<?=bin2hex($resource->id)?>" name="id" /><input type="submit" value="Editer" />
							</form></td>
					</tr>
				<?php }?>
				</tbody>
			</table>
		<?php if($pagging->lastPage()>0){?>
			<div class="pagging">
		<?php if($pagging->previousPage !==null){?>
		<a href="?p=<?=$pagging->previousPage?>&amp;ct=<?=$mimeType?>">&lt;</a>
		<?php }?>
		<?php foreach($pagging->pages as $page){ ?>
		<span class="pageLinks"><a <?=$page==$pagging->page?'class="selected"':'' ?> href="?p=<?=$page?>&amp;ct=<?=$mimeType?>"><?=$page?></a></span>
		<?php }?>
		<?php if($pagging->nextPage!==null){?>
		<a href="?p=<?=$pagging->nextPage?>&amp;ct=<?=$mimeType?>">&gt;</a>
		<?php }?>
			</div>
		<?php }?>
		</fieldset>
		<fieldset>
			<legend>Créer une nouvelle ressource</legend>
			<form id="CREATE_RESOURCE_FORM" method="POST" enctype="multipart/form-data" action="/system/service/content/create-resource.php">
				<fieldset>
					<legend>Contenu</legend>
					<p>Récupérer le contenu à partir</p>
					<fieldset>
						<legend>d'une URL :</legend>
						<label>URL :</label> <input name="contentURL" type="url" />
					</fieldset>
					<fieldset>
						<legend>d'un fichier : </legend>
						<label>Fichier : </label> <input name="contentFile" type="file" />
					</fieldset>
				</fieldset>
				<div>
					<input type="submit" value="Créer" />
				</div>
			</form>
		</fieldset>
	</div>
</body>
</html>