<?php
// dependencies
require_once '../../../../configuration/config.inc.php';
use xo\content\ContentService;
use xo\cms\core\Configuration;
use xo\www\ServiceRequestUtils;
use xo\cms\Pagging;
use xo\www\HttpRequest;
session_start ();
if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}
$title = 'Sélectionner un liens';
$service = new ContentService ( Configuration::getInstance () );
$limit = 20;
$count = $service->getResourceRefsCount ();
$pagging = new Pagging ( $count, $limit );
$httpRequest = new HttpRequest ();
if ($httpRequest->hasGetData ( "p" )) {
	$currentPage = $httpRequest->getGetDataAsInteger ( "p" );
	if ($currentPage < 0) {
	} elseif ($currentPage > $pagging->lastPage ()) {
		header ( "Status: 301 Moved Permanently", false, 301 );
		header ( "Location: ?p={$pagging->lastPage ()}" );
		exit ();
	} else {
		$pagging->setPage ( $currentPage );
	}
} else {
	$pagging->setPage ( 0 );
}
$items = $service->getResourceRefs ( $pagging->offset (), $limit );

?>
<!DOCTYPE html>
<html>
<head>
<?php include '../../html-headers.tpl.php'; ?>
<link type="text/css" href="/style/content/resources.css" rel="stylesheet" />
<script type="text/javascript">
function select(id){
	opener.dispatchEvent( new CustomEvent("select",{
				detail: {
					message: id,
					time: new Date(),
				},
				bubbles: true,
				cancelable: true
			}
		));
	close();
}
</script>
</head>
<body>
	<div id="BODY">
		<h1><?=$title?></h1>
		<fieldset>
			<legend>Liste des liens (<?=$count?>) :</legend>
			<table class="table">
				<thead>
					<tr>
						<th>Nom</th>
						<th>Lien</th>
						<th>Commentaire</th>
						<th></th>
					</tr>
				</thead>
				<tbody>
				<?php foreach ($items as $item){?>
					<tr>
						<td><?=htmlentities($item->label)?></td>
						<td><a target="_BLANK" href="<?=$item->url?>"><?=$item->url?></a></td>
						<td><?=htmlentities($item->comment)?></td>
						<td><button onclick="select('<?=bin2hex($item->id)?>')">Choisir</button></td>
					</tr>
				<?php }?>
				</tbody>
			</table>
				<?php if($pagging->lastPage()>0){?>
			<div class="pagging">
		<?php if($pagging->previousPage !==null){?>
		<a href="?p=<?=$pagging->previousPage?>">&lt;</a>
		<?php }?>
		<?php foreach($pagging->pages as $page){ ?>
		<span class="pageLinks"><a <?=$page==$pagging->page?'class="selected"':'' ?> href="?p=<?=$page?>"><?=$page?></a></span>
		<?php }?>
		<?php if($pagging->nextPage!==null){?>
		<a href="?p=<?=$pagging->nextPage?>">&gt;</a>
		<?php }?>
			</div>
		<?php }?>
		</fieldset>
	</div>
</body>
</html>
