<?php
// dependencies
require_once '../../../../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\cms\WebPage;
use xo\content\ContentService;
use xo\www\HttpRequest;
use xo\www\ServiceRequestUtils;

session_start ();

if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}
$title = 'Administration - Contenu - Editer une ressource';
$service = new ContentService ( Configuration::getInstance () );

$httpRequest = new HttpRequest ();

if ($httpRequest->hasGetData ( "id" )) {
	$idStr = $httpRequest->getGetDataAsText ( "id" );
	$idBin = hex2bin ( $idStr );
	$contentService = new ContentService ( Configuration::getInstance () );
	$resource = $contentService->getCurrentResource ( $idBin );
	if ($resource === null) {
		header ( "Status: 404 Not Found", false, 404 );
		exit ();
	}
	$contentService->loadData ( $resource );
} else {
	header ( "Status: 404 Not Found", false, 404 );
	exit ();
}

?>
<!DOCTYPE html>
<html>
<head>
<?php include '../../html-headers.tpl.php'; ?>
<script type="text/javascript" src="/script/ckeditor/ckeditor.js"></script>
<link type="text/css" href="/style/content/resource.css" rel="stylesheet" />
</head>
<body>
	<div id="BODY">
		<?php include '../../menu.tpl.php'; ?>
		<h1><?=$title?></h1>
		<?php include '../menu.tpl.php'; ?>
		<fieldset>
			<legend>Identifiant :</legend>
			<div><?=bin2hex($resource->id)?></div>
		</fieldset>
		<fieldset>
			<legend>Voir / Télécharger le contenu</legend>
			<?php if(($resource instanceof  WebPage)){ ?>
			<a target="_BLANK" href="/system/service/content/view-resource?id=<?=bin2hex($resource->id)?>">Prévisualiser la page</a>
			<?php }else{?>
			<a target="_BLANK" href="/system/service/content/display-data?id=<?=bin2hex($resource->data->id)?>">Voir le fichier</a> <a download="download" target="_BLANK" href="/system/service/content/display-data?id=<?=bin2hex($resource->data->id)?>">Télécharger le fichier</a>
			
			
			<?php } ?>
		</fieldset>
		<?php printAncestors($idBin)?>
		
		<fieldset>
			<legend>Mise en ligne</legend>
			<form id="UPDATE_RESOURCE_MAP_FORM" method="POST" action="/system/service/content/update-resource-map.php">
				<div>
					<label>Chemin :</label> <input name="path" value="<?=htmlentities($resource->path->path)?>" required="required" placeholder="/le/chemin/voulu.txt" name="path" type="text" pattern="(/|(/[a-z0-9-\.]+)+)" />
				</div>
				<div>
					<label>En ligne : </label> <input <?= $resource->path->online?'checked="checked"':'' ?> name="online" type="checkbox" />
				</div>
				<input type="hidden" name="pathId" type="text" value="<?=bin2hex($resource->path->id)?>" />
				<div>
					<input type="submit" value="Valider" />
				</div>
			</form>

		</fieldset>
		<?php if(($resource instanceof  WebPage)){ ?>
		<fieldset>
			<legend>Info Techniques</legend>
			<form id="UPDATE_WEBPAGE_FORM" method="POST" action="/system/service/content/update-webpage.php">
				<div>
					<label>Template</label> <input value="<?=htmlentities($resource->templateName)?>" required="required" name="template" type="text" />
				</div>
				<div>
					<label>Parametres</label>
					<textarea name="parameters"><?=htmlentities($resource->parameters)?></textarea>
				</div>


				<div>
					<input type="hidden" name="id" value="<?=bin2hex($resource->id)?>"> <input type="submit" value="Modifier">
				</div>
			</form>
		</fieldset>
		<fieldset>
			<legend>Données pour le référencement</legend>
			<form id="UPDATE_WEBPAGE_SEO_FORM" method="POST" action="/system/service/content/update-webpage-seo.php">
				<div>
					<label>Titre</label> <input value="<?=htmlentities($resource->seoTitle)?>" required="required" name="title" type="text" />
				</div>
				<div>
					<label>Description</label>
					<textarea name="description" required="required" name="description"><?=htmlentities($resource->seoDescription)?></textarea>
				</div>
				<div>
					<label>Image</label>
					<div class="preview">
						<?php if($resource->seoImage!=null){?>
						<img src="/system/service/content/preview-resource.php?id=<?=bin2hex($resource->seoImage->id)?>" /> 
							<?php } ?>
						</div>
					<input value="<?=htmlentities($resource->seoImage==null?null:bin2hex($resource->seoImage->id))?>" pattern="[a-f0-9]{32}" required="required" name="image" type="text" />
				</div>

				<div>
					<input type="hidden" name="id" value="<?=bin2hex($resource->id)?>"> <input type="submit" value="Modifier">
				</div>
			</form>
		</fieldset>
		
		<?php }?>
		
		<fieldset>
			<legend>Informations</legend>
			<form id="UPDATE_RESOURCE_FORM" method="POST" action="/system/service/content/update-resource.php">
				<div>
					<label>Nom</label> <input value="<?=htmlentities($resource->name)?>" required="required" name="name" type="text" />
				</div>
				<div>
					<label>Commentaire</label>
					<textarea name="comment"><?=htmlentities($resource->comment)?></textarea>
				</div>
				<div>
					<label>Description</label>
					<textarea name="description"><?=htmlentities($resource->description)?></textarea>
				</div>

				<input type="hidden" name="id" value="<?=bin2hex($resource->id)?>">
				<div>
					<input type="submit" value="Modifier">
				</div>

			</form>
		</fieldset>
		<?php if(!($resource instanceof  WebPage)){?>
		<fieldset>
			<legend>Modifier le contenu </legend>
			<form id="UPDATE_RESOURCE_DATA_FORM" method="POST" enctype="multipart/form-data" action="/system/service/content/update-resource-data.php">
				<?php if($resource->preview->id!==null){?>
				<div>
					<img src="/system/service/content/display-data.php?id=<?=bin2hex($resource->preview->id)?>" alt="Preview" />
				</div>
				<?php }?>
				<div>
					<fieldset>
						<legend>Récupérer le contenu à partir d'une URL :</legend>
						<label>URL :</label> <input name="contentURL" type="url" />
					</fieldset>
					<fieldset>
						<legend>Récupérer le contenu à partir d'un fichier : </legend>
						<label>Fichier : </label> <input name="contentFile" type="file" />
					</fieldset>
					<?php if(($resource->data->contentType=="text/html")){?>
					<fieldset>
						<legend>Editer le contenu : </legend>
						<textarea id="CONTENT_EDITOR" rows="10" cols="80" name="content"><?=$contentService->getResourceData($resource->data)?></textarea>
						<script type="text/javascript">CKEDITOR.replace( 'CONTENT_EDITOR' );</script>
					</fieldset>
					<?php } ?>
				</div>
				<input type="hidden" name="resourceId" value="<?=bin2hex($resource->id)?>">
				<div>
					<input type="submit" value="Modifier">
				</div>
			</form>
		</fieldset> 
<?php }?>
		<?php if(($resource instanceof  WebPage)){?>
	
		<fieldset>
			<legend>Données disponibles sur la page </legend>

			<a href="/modules/content/list?id=<?=bin2hex($resource->model->webPageDataList->id)?>">Editer la liste</a>

		</fieldset>
		
<?php }?>
	</div>
</body>
</html>
