<?php
// dependencies
require_once '../../../../configuration/config.inc.php';
use xo\content\ContentService;
use xo\cms\core\Configuration;
use xo\www\ServiceRequestUtils;
use xo\www\HttpRequest;
use xo\cms\WebPage;
use xo\cms\Resource;
use xo\cms\ResourceRef;
use xo\cms\DataList;

session_start ();

if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_CONTENT' )) {
	exit ( 0 );
}
$title = 'Administration - Contenu - Editer une ressource';
$service = new ContentService ( Configuration::getInstance () );

$httpRequest = new HttpRequest ();
if ($httpRequest->hasGetData ( "id" )) {
	$idStr = $httpRequest->getGetDataAsText ( "id" );
	$idBin = hex2bin ( $idStr );
	$contentService = new ContentService ( Configuration::getInstance () );
	$item = $contentService->getListItem ( $idBin );
	if ($item === null) {
		header ( "Status: 404 Not Found", false, 404 );
		exit ();
	} else {
		$listSize = $contentService->getListSize ( $item->list->id );
	}
} else {
	header ( "Status: 404 Not Found", false, 404 );
	exit ();
}
?>
<!DOCTYPE html>
<html>
<head>
<?php include '../../html-headers.tpl.php'; ?>
<link type="text/css" href="/style/content/resource.css" rel="stylesheet" />
</head>
<body>
	<div id="BODY">
		<?php include '../../menu.tpl.php'; ?>
		<h1><?=$title?></h1>
		<?php include '../menu.tpl.php'; ?>
		
		<a href="/modules/content/list?id=<?=bin2hex($item->list->id)?>">Retour à la liste</a>

	</div>
</body>
</html>
