<?php
// dependencies
require_once '../../../../configuration/config.inc.php';
use xo\access\Access;
use xo\access\AccessFrenchUtils;
use xo\access\AccessService;
use xo\cms\core\Configuration;
use xo\www\ServiceRequestUtils;

session_start ();

if (! ServiceRequestUtils::checkAuthorization ( 'MANAGE_ACCESS' )) {
	exit ( 0 );
}
$accessId = null;
$service = new AccessService ( Configuration::getInstance()->db() );
if (array_key_exists ( "id", $_GET )) {
	$accessId = $_GET ['id'];
}
if ($accessId == null) {
	// TODO
}
$access = $service->getAccess ( $accessId );
if ($access == null) {
	// TODO
}
$allRoles = $service->getRoles ();
$accessRoles = $service->getAccessRoles ( $accessId );
$roles = array ();
$hasRole = array ();
foreach ( $allRoles as $role ) {
	$roles [$role->getCode ()] = $role;
	$hasRole [$role->getCode ()] = false;
}
foreach ( $accessRoles as $role ) {
	$hasRole [$role->getCode ()] = true;
}
$i18nUtils = new AccessFrenchUtils ();
$title = 'Administration - Accès - Gestion des accès';
?>
<!DOCTYPE html>
<html>
<head>
<?php include '../../html-headers.tpl.php'; ?>
<link type="text/css" href="/style/access/access.css" rel="stylesheet" />
</head>
<body>
	<div id="BODY">
		<?php include '../../menu.tpl.php'; ?>
		<h1>
			<?= $title?>
		</h1>
		<?php include '../menu.tpl.php'; ?>
		<fieldset>
			<legend>Information</legend>
			<?= $access->getId()?>
			<?= $access->getLogin()?>
			<?= $access->getEmail()?>
		</fieldset>
		<fieldset>
			<legend>Roles</legend>
			<form id="SET_ACCESS_ROLES" action="/system/service/access/set-access-roles.php" method="POST">
				<table>
					<tr>
						<th>&nbsp;</th>
						<th>Libellé</th>
					</tr>
					<?php
					$i = 0;
					foreach ( $roles as $role ) {
						?>
					<tr>
						<td><input name="role-ids[]" value="<?= $role->getId() ?>" type="checkbox" <?= $hasRole[$role->getCode()]?'checked="checked"':'' ?> /></td>
						<td><label>
								<?= $role->getLabel()?>
							</label></td>
					</tr>
					<?php
						
$i ++;
					}
					?>
				</table>
				<div>
					<input type="hidden" value="<?= $access->getId() ?>" name="access-id" /> <input type="submit" value="Modifier" />
				</div>
			</form>
		</fieldset>
		<fieldset>
			<legend>Statut</legend>
			<form id="UPDATE_ACCESS_STATUS" action="/system/service/access/update-access-status.php" method="POST">
				<?php foreach(Access::getAllStatus() as $status){ ?>
				<input name="status" value="<?=$status?>" type="radio" <?= $status==$access->getStatus()?'checked="checked"':'' ?> /> <label>
					<?= $i18nUtils->getAccessStatusLabel($status)?>
				</label>
				<?php } ?>
				<input type="hidden" value="<?= $access->getId() ?>" name="access-id" /> <input type="submit" value="Modifier" />
			</form>
		</fieldset>
		<fieldset>
			<legend>Modifier le mot de passe</legend>
			<form id="UPDATE_ACCESS_PASSWORD" action="/system/service/access/update-access-password.php" method="POST">
				<input name="password1" type="password" placeholder="Mot de passe" /> <input name="password2" type="password" placeholder="Confirmation" /> <input
					type="hidden" value="<?= $access->getId() ?>" name="access-id" /> <input type="submit" value="Modifier" />
			</form>
		</fieldset>
		<fieldset>
			<legend>Assigner un mot de passe aléatoire</legend>
			<form id="GENERATE_ACCESS_PASSWORD" action="/system/service/access/generate-access-password.php" method="POST">
				<input type="hidden" value="<?= $access->getId() ?>" name="access-id" /> <input type="submit" value="Générer" />
			</form>
		</fieldset>
	</div>
</body>
</html>