<?php
// dependencies
require_once '../configuration/config.inc.php';
use xo\cms\core\Configuration;
use xo\access\AccessService;
use xo\www\ServiceRequestUtils;

session_start ();
$redirect = ServiceRequestUtils::getLoginRedirectCookie ();

?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
<link type="text/css" href="/style/home.css" rel="stylesheet" />
</head>
<body>
	<div id="BODY">
		<?php include 'modules/menu.tpl.php'; ?>
		<h1>Administration</h1>
		<fieldset>
			<legend>Info sur la connexion :</legend>
			<?php
			$accessService = new AccessService ( Configuration::getInstance ()->db () );
			$currentAccess = $accessService->getCurrentAccess ();
			if ($currentAccess != null) {
				?>
			<div>
				Vous êtes connecté :
				<?= $currentAccess->getLogin()?>
			</div>
			<form id="LOGOUT" action="/system/service/access/logout.php" method="post">
				<input type="submit" value="Se déconnecter" />
			</form>
			<?php
			} else {
				?>
			<div>Vous n'êtes pas connecté.</div>
			<form id="LOGIN" action="/system/service/access/login.php" method="post">
				<input type="email" name="login" placeholder="Login" /> <input type="password" name="password" placeholder="Mot de passe" /> <input type="hidden"
					name="redirect" value="<?=$redirect?>" /> <input type="submit" value="Se connecter" />
			</form>
			<?php
			}
			?>
		</fieldset>
		<?php if($currentAccess!=null){?>
		<fieldset>
			<legend>Modules accessibles:</legend>
			<div class="mainMenu">
				<?php if(ServiceRequestUtils::checkAuthorization('MANAGE_ACCESS',false)){?>
				<a class="item" class="item" href="/modules/access">Accès</a>
				<?php } ?>
				<?php if(ServiceRequestUtils::checkAuthorization('MANAGE_MESSAGE',false)){?>
				<a class="item" href="/modules/message">Messages</a>
				<?php } ?>
				<?php if(ServiceRequestUtils::checkAuthorization('MANAGE_CONTENT',false)){?>
				<a class="item" href="/modules/content">Contenu</a>
				<?php } ?>
			</div>
		</fieldset>
		<?php }?>
	</div>
</body>
</html>
