<?php use xo\cms\Pagging;?>
<?php use xo\www\HttpRequest;?>
<div class="main partners">
	<div class="titles">
	<?=$ctx->dataAsHtml("titles")?>
	</div>
	<hr />
	<div class="intro"><?=$ctx->dataAsHtml("intro")?></div>
	<?php 
	
	$partners=$ctx->data("partners");
	$limit = 50;
	$count = $ctx->data("partners")->size(false);
	$pagging = new Pagging ( $count, $limit );
	$httpRequest = new HttpRequest ();
	if ($httpRequest->hasGetData ( "p" )) {
		$currentPage = $httpRequest->getGetDataAsInteger ( "p" );
		if ($currentPage < 0) {
			header ( "Status: 301 Moved Permanently", false, 301 );
			header ( "Location: ?p=0" );
		} elseif ($currentPage > $pagging->lastPage ()) {
			header ( "Status: 301 Moved Permanently", false, 301 );
			header ( "Location: ?p={$pagging->lastPage ()}" );
			exit ();
		} else {
			$pagging->setPage ( $currentPage );
		}
	} else {
		$pagging->setPage ( 0 );
	}
	?>
	<div class="listing" data-list-id="<?=bin2hex($partners->id)?>" >
	<?php 
	
	
	foreach ($partners->getItems(true,$pagging->offset(),$limit,false) as $item){
		$partner=$item->data;
		?>
		<div class="item " data-ref-id="<?=bin2hex($partner->id)?>">
			<div class="c1">
				<div class="title"><?=htmlentities($partner->label)?></div>
				<div class="description"><?=$partner->description?></div>
			</div>
			<div class="c2">
				<div class="img">
					<a  href="<?=htmlentities($partner->url)?>">
					<img class="under" src="<?=htmlentities($partner->img->path->path)?>" />
					<img class="over" src="<?=htmlentities($partner->imgOver->path->path)?>" />	
						</a>
				</div>
				<a href="<?=htmlentities($partner->url)?>" class="link">En savoir plus</a>
			</div>
		</div>
		
		
		<?php }?>
	</div>
</div>
<?php 

include 'pagging.tpl.php'?>
