<?php use xo\cms\Pagging;?>
<?php use xo\www\HttpRequest;?>
<?php 
$articles = $ctx->data ( "articles" );
$limit = 5;
$count = $articles->size ( false );
$pagging = new Pagging ( $count, $limit );
$httpRequest = new HttpRequest ();
if ($httpRequest->hasGetData ( "p" )) {
	$currentPage = $httpRequest->getGetDataAsInteger ( "p" );
	if ($currentPage < 0) {
		header ( "Status: 301 Moved Permanently", false, 301 );
		header ( "Location: ?p=0" );
	} elseif ($currentPage > $pagging->lastPage ()) {
		header ( "Status: 301 Moved Permanently", false, 301 );
		header ( "Location: ?p={$pagging->lastPage ()}" );
		exit ();
	} else {
		$pagging->setPage ( $currentPage );
	}
} else {
	$pagging->setPage ( 0 );
}
?>
<div class="main events">
	<div class="titles">
	<?=$ctx->dataAsHtml("titles")?>
	</div>
	<hr />
	<div class="intro"><?=$ctx->dataAsHtml("intro")?></div>
	<div class="listing" data-list-id="<?=bin2hex($articles->id)?>">
	<?php
	foreach ( $articles->getItems ( true, $pagging->offset (), $limit, false ) as $item ) {
		$article = $item->data;
		
	?>
		<div class="item " data-ref-id="<?=bin2hex($article->id)?>">
		<?=$ctx->html($article)?>
		</div>
	<?php 
	}	
	?>
	
	</div>
	
</div>
