<?php

namespace xo\cms;

class Template {
	private $directory;
	private $name;
	private $locale;
	private $suffix;
	function __construct($directory, $locale, $name, $suffix = '.tpl.php') {
		$this->directory = $directory;
		$this->locale = $locale;
		$this->name = $name;
		$this->suffix = $suffix;
	}
	function render($out, $ctx) {
		ob_start ();
		include $this->getTemplatePath ();
		fwrite ( $out, ob_get_clean () );
	}
	function renderToString($ctx) {
		ob_start ();
		include $this->getTemplatePath ();
		return ob_get_clean ();
	}
	function getTemplatePath() {
		return strtolower ( $this->directory . DIRECTORY_SEPARATOR . $this->locale . DIRECTORY_SEPARATOR . $this->name . $this->suffix );
	}
}
?>