<?php

namespace xo\authtoken;

class AuthToken {
	private $token;
	private $since;
	private $until;
	private $authCode;
	private $payLoad;
	public function __construct($token, $authCode, $payLoad, $since, $until) {
		$this->token = $token;
		$this->since = $since;
		$this->until = $until;
		$this->payLoad = $payLoad;
		$this->authCode = $authCode;
	}
	public function getToken() {
		return $this->token;
	}
	public function getPayload() {
		return $this->payLoad;
	}
	public function getTokenAsString() {
		return bin2hex ( $this->token );
	}
	public function isValid($authCode) {
		$time = time ();
	
		return $authCode == $this->authCode && $time > $this->since && $time < $this->until;
	}
}
?>