<?php

namespace xo\access;

class LoginPasswordUtils {
	private static $SALT_LENGTH = 16;
	private static $SECOND_SALT = "afrTpM106";
	private static function saltPassword($password, $salt) {
		$passwordLength = strlen ( $password );
		$step = abs ( crc32 ( $password ) ) % 10;
		$s = 0;
		$saltPassword = self::$SECOND_SALT;
		$saltLength = strlen ( $salt );
		for($p = 0; $p < $passwordLength; $p ++) {
			$saltPassword .= $password [$p];
			for($i = 0; $i < $step; $i ++) {
				if ($s < $saltLength) {
					$saltPassword .= $salt [$s ++];
				}
			}
		}
		for($i = 0; $i < $step; $i ++) {
			if ($s < $saltLength) {
				$saltPassword .= $salt [$s ++];
			}
		}
		
		return $saltPassword;
	}
	private static function generateSalt() {
		$salt = self::generateRandomCharSequence ( self::$SALT_LENGTH );
		return $salt;
	}
	public static function generateRandomCharSequence($length, $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789@$#') {
		$maxIdx = strlen ( $chars ) - 1;
		$password = '';
		for($i = 0; $i < $length; $i ++) {
			$idx = rand ( 0, $maxIdx );
			$password .= $chars [$idx];
		}
		return $password;
	}
	public static function generateRandomPassword($minLength, $maxLength) {
		$length = rand ( $minLength, $maxLength );
		$password = self::generateRandomCharSequence ( $length );
		return $password;
	}
	private static function hash($password, $salt) {
		return hex2bin(sha1 ( self::saltPassword ( $password, $salt ) ));
	}
	private $salt;
	private $hash;
	public function __construct($password, $salt = null) {
		if ($salt == null) {
			$this->salt = self::generateSalt ();
		} else {
			$this->salt = $salt;
		}
		$this->hash = self::hash ( $password, $this->salt );
	}
	public function getSalt() {
		return $this->salt;
	}
	public function getHash() {
		return $this->hash;
	}
}

?>